/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/envilib/envigetpoint.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#include <stdio.h>
#include "envi.h"

extern FILE    *pltout;

envigetpoint (termout, x, y)
    FILE           *termout;
    int            *x, *y;
{
char            string[80];
char            c;

    envisetmode (REG);
    envipanoff ();		/* Turn off panning */
    envicursoron ();		/* Turn on the cursor */
    fflush (pltout);

    fflush (termout);
    fgets (string, 79, termout);/* Wait for a return */
    fflush (termout);

    fprintf (pltout, "%cYC", ESC);	/* Ask for position of cursor */
    fflush (pltout);
    c = '\0';
    fflush (termout);
    fscanf (termout, "%4x%4x\n%c\n", x, y, &c);	/* Get answer */

    /* Undo the window weirdness */
    *x = (*x + 1) / 4;
    *y = (*y + 0) / 4;
/*
 * The plus 1 and 0 are to try to make it land on the right point.
 * Sometimes we get one off. I'm not sure where the problem lies.
 */

    envipanon ();		/* Turn on panning */
    envicursoroff ();		/* Turn the cursor off again */
    fflush (pltout);
    if (c == 'q')
	return (1);
    else
	return (0);
}
