/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./lvplot/vp_utext.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */
/*
 * Joe Dellinger, Oct 17, 1987
 * Made Fortran and C calling arguments match.
 */

#include <stdio.h>
#include <vplot.h>
#include "vp_pc.h"

#ifdef FORTRAN

#define UTEXT	vpwutext_
#define TEXT	vpwtext_
#define X		*x
#define Y		*y
#define SIZE	*size
#define ORIENT	*orient
#define XP		&xp
#define YP		&yp

#else

#define UTEXT	vp_utext
#define TEXT	vp_text
#define X		x
#define Y		y
#define SIZE	size
#define ORIENT	orient
#define XP		xp
#define YP		yp

#endif

#ifdef FORTRAN
UTEXT (x, y, size, orient, string, nchars)
#else
UTEXT (x, y, size, orient, string)
#endif
    float           X, Y;
    int             SIZE, ORIENT;
    char           *string;
#ifdef FORTRAN
    int            *nchars;
#endif
{
float           xp, yp;
    xp = vp_pc._x0 + (X - vp_pc._xu0) * vp_pc._xscl;
    yp = vp_pc._y0 + (Y - vp_pc._yu0) * vp_pc._yscl;
#ifdef FORTRAN
    TEXT (XP, YP, size, orient, string, nchars);
#else
    TEXT (XP, YP, size, orient, string);
#endif
}
