/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./lvplot/vp_uraster.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#include <stdio.h>
#include <vplot.h>
#include "vp_pc.h"

#ifdef FORTRAN

#define RASTER		vpraster_
#define URASTER		vpuraster_
#define XLL		*xll
#define YLL		*yll
#define XPIX		*xpix
#define YPIX		*ypix
#define PPI		*ppi
#define	BIT		*bit
#define OFFSET		*offset
#define	BLAST		*blast
#define	ORIENT		*orient
#define	INVERT		*invert

#else

#define RASTER		vp_raster
#define URASTER		vp_uraster
#define XLL		xll
#define YLL		yll
#define XPIX		xpix
#define YPIX		ypix
#define PPI		ppi
#define	BIT		bit
#define OFFSET		offset
#define	BLAST		blast
#define	ORIENT		orient
#define	INVERT		invert

#endif

URASTER (array, blast, bit, offset, xpix, ypix, xll, yll, ppi, xur, yur, orient, invert)
    unsigned char  *array;
    float           XLL, YLL, *xur, *yur, PPI;
    int             XPIX, YPIX, BIT, OFFSET, BLAST, ORIENT, INVERT;
{
float           x1, y1, x2, y2;

    x1 = vp_pc._x0 + (XLL - vp_pc._xu0) * vp_pc._xscl;
    y1 = vp_pc._y0 + (YLL - vp_pc._yu0) * vp_pc._yscl;

    if (PPI == 0.)
    {
	x2 = vp_pc._x0 + (*xur - vp_pc._xu0) * vp_pc._xscl;
	y2 = vp_pc._y0 + (*yur - vp_pc._yu0) * vp_pc._yscl;
    }

    RASTER (array, BLAST, BIT, OFFSET, XPIX, YPIX, x1, y1, PPI, &x2, &y2, ORIENT, INVERT);

    if (PPI != 0. && vp_pc._xscl != 0. && vp_pc._yscl != 0.)
    {
	*xur = (x2 - vp_pc._x0) / vp_pc._xscl + vp_pc._xu0;
	*yur = (y2 - vp_pc._y0) / vp_pc._yscl + vp_pc._yu0;
    }
}
