/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./lvplot/vp_ugtext.c
 *
 * Joe Dellinger (SEP), Jan 14 1988
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#include <stdio.h>
#include <vplot.h>
#include "vp_pc.h"

#ifdef FORTRAN

#define UTEXT	vpwugtext_
#define TEXT	vpwgtext_
#define X		*x
#define Y		*y
#define XP		&xp
#define YP		&yp
#define XPATH		*xpath
#define YPATH		*ypath
#define XPATHP		&xpathp
#define YPATHP		&ypathp
#define XUP		*xup
#define YUP		*yup
#define XUPP		&xupp
#define YUPP		&yupp

#else

#define UTEXT	vp_ugtext
#define TEXT	vp_gtext
#define X		x
#define Y		y
#define XP		xp
#define YP		yp
#define XPATH		xpath
#define YPATH		ypath
#define XPATHP		xpathp
#define YPATHP		ypathp
#define XUP		xup
#define YUP		yup
#define XUPP		xupp
#define YUPP		yupp

#endif

#ifdef FORTRAN
UTEXT (x, y, xpath, ypath, xup, yup, string, nchars)
#else
UTEXT (x, y, xpath, ypath, xup, yup, string)
#endif
    float           X, Y;
    float           XPATH, YPATH;
    float           XUP, YUP;
    char           *string;
#ifdef FORTRAN
    int            *nchars;
#endif
{
float           xp, yp;
float           xpathp, ypathp;
float           xupp, yupp;

    xp = vp_pc._x0 + (X - vp_pc._xu0) * vp_pc._xscl;
    yp = vp_pc._y0 + (Y - vp_pc._yu0) * vp_pc._yscl;
    xpathp = XPATH * vp_pc._xscl;
    ypathp = YPATH * vp_pc._yscl;
    xupp = XUP * vp_pc._xscl;
    yupp = YUP * vp_pc._yscl;

#ifdef FORTRAN
    TEXT (XP, YP, XPATHP, YPATHP, XUPP, YUPP, string, nchars);
#else
    TEXT (XP, YP, XPATHP, YPATHP, XUPP, YUPP, string);
#endif
}
