/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./lvplot/vp_uclip.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#include <stdio.h>
#include <vplot.h>
#include "vp_pc.h"

#ifdef FORTRAN

#define UCLIP	vpuclip_
#define CLIP	vpclip_
#define XMIN	*xmin
#define YMIN	*ymin
#define XMAX	*xmax
#define YMAX	*ymax
#define XPMIN	&xpmin
#define YPMIN	&ypmin
#define XPMAX	&xpmax
#define YPMAX	&ypmax

#else

#define UCLIP	vp_uclip
#define CLIP	vp_clip
#define XMIN	xmin
#define YMIN	ymin
#define XMAX	xmax
#define YMAX	ymax
#define XPMIN	xpmin
#define YPMIN	ypmin
#define XPMAX	xpmax
#define YPMAX	ypmax

#endif

UCLIP (xmin, ymin, xmax, ymax)
    float           XMIN, YMIN, XMAX, YMAX;
{
float           xpmin, ypmin, xpmax, ypmax;
    xpmin = vp_pc._x0 + (XMIN - vp_pc._xu0) * vp_pc._xscl;
    ypmin = vp_pc._y0 + (YMIN - vp_pc._yu0) * vp_pc._yscl;
    xpmax = vp_pc._x0 + (XMAX - vp_pc._xu0) * vp_pc._xscl;
    ypmax = vp_pc._y0 + (YMAX - vp_pc._yu0) * vp_pc._yscl;
    CLIP (XPMIN, YPMIN, XPMAX, YPMAX);
}
