/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./lvplot/vp_tfont.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 *
 * Joe Dellinger, Dec 7 1987
 *	If they call vp_tfont, just write out the vplot command.
 *	Don't bother trying to second guess them! It's only
 *	asking for trouble.
 */

#include <stdio.h>
#include <vplot.h>
#include "vp_pc.h"

#ifdef FORTRAN

#define FONT	*font
#define PREC   *prec
#define OVLY   *ovly
#define TFONT   vptfont_

#else

#define FONT	font
#define PREC   prec
#define OVLY   ovly
#define TFONT   vp_tfont

#endif

TFONT (font, prec, ovly)
    int             FONT, PREC, OVLY;
{
    vp_pc._font = FONT;
    vp_pc._prec = PREC;
    vp_pc._ovly = OVLY;

    putc (VP_TXFONTPREC, vp_pc._pltout);
    puth (vp_pc._font, vp_pc._pltout);
    puth (vp_pc._prec, vp_pc._pltout);
    puth (vp_pc._ovly, vp_pc._pltout);

    return;
}
