/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./lvplot/vp_stretch.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#include <stdio.h>
#include <vplot.h>
#include "vp_pc.h"

#ifdef FORTRAN

#define STRETCH	vpstretch_
#define XMIN	*xmin
#define YMIN	*ymin
#define XMAX	*xmax
#define YMAX	*ymax

#else

#define STRETCH	vp_stretch
#define XMIN	xmin
#define YMIN	ymin
#define XMAX	xmax
#define YMAX	ymax

#endif

extern int      cur_style;

STRETCH (xmin, ymin, xmax, ymax)
    float           XMIN, YMIN, XMAX, YMAX;
{

    vp_uorig (XMIN, YMIN);
    vp_orig (0., 0.);

    if (cur_style == ROTATED)
    {
	vp_scale (ROTATED_HEIGHT / (XMAX - XMIN), (ROTATED_HEIGHT / SCREEN_RATIO) / (YMAX - YMIN));
    }
    else
    {
	vp_scale ((STANDARD_HEIGHT / SCREEN_RATIO) / (XMAX - XMIN), STANDARD_HEIGHT / (YMAX - YMIN));
    }
}
