/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./lvplot/vp_pmark.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 * Joe Dellinger Jan 14 1988
 *	Do rounding.
 */

#include <stdio.h>
#include <vplot.h>
#include "round.h"
#include "vp_pc.h"

#ifdef FORTRAN

#ifdef UUU
#define PMARK	vpupmark_
#else UUU
#define PMARK	vppmark_
#endif UUU
#define NPTS	*npts
#define MTYPE	*mtype
#define MSIZE	*msize
#define XP xp2
#define YP yp2

#else

#ifdef UUU
#define PMARK	vp_upmark
#else UUU
#define PMARK	vp_pmark
#endif UUU
#define NPTS	npts
#define MTYPE	mtype
#define MSIZE	msize
#define XP xp
#define YP yp

#endif

PMARK (npts, mtype, msize, xp, yp)
    float          *xp, *yp;
    int             NPTS, MTYPE, MSIZE;
{
int             i, ix, iy;

#ifdef FORTRAN
float          *xp2, *yp2;

    xp2 = xp;
    yp2 = yp;
#endif FORTRAN

    putc (VP_PMARK, vp_pc._pltout);
    puth (NPTS, vp_pc._pltout);
    puth (MTYPE, vp_pc._pltout);
    puth (MSIZE, vp_pc._pltout);

#ifdef UUU			/* units are user units */
    for (i = 0; i < NPTS; i++)
    {
	ix = ROUND ((vp_pc._x0 + ((*XP) - vp_pc._xu0) * vp_pc._xscl) * RPERIN);
	iy = ROUND ((vp_pc._y0 + ((*YP) - vp_pc._yu0) * vp_pc._yscl) * RPERIN);
	XP++;
	YP++;
	puth (ix, vp_pc._pltout);
	puth (iy, vp_pc._pltout);
    }
#else UUU			/* units are inches */
    for (i = 0; i < NPTS; i++)
    {
	ix = ROUND ((*XP) * RPERIN);
	iy = ROUND ((*YP) * RPERIN);
	XP++;
	YP++;
	puth (ix, vp_pc._pltout);
	puth (iy, vp_pc._pltout);
    }
#endif UUU
}
