/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./lvplot/vp_patload.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#include <stdio.h>
#include <vplot.h>
#include "vp_pc.h"

#ifdef FORTRAN

#define PATLOAD vppatload_
#define PPI   *ppi
#define NX    *nx
#define NY    *ny
#define IPAT  *ipat

#else

#define PATLOAD vp_patload
#define PPI   ppi
#define NX    nx
#define NY    ny
#define IPAT  ipat

#endif

PATLOAD (ppi, nx, ny, ipat, colarray)
    int             PPI, NX, NY, IPAT;
    int            *colarray;
{
int             c;
int             ii;

    putc (VP_PATLOAD, vp_pc._pltout);
    c = PPI;
    puth (c, vp_pc._pltout);
    c = NX;
    puth (c, vp_pc._pltout);
    c = NY;
    puth (c, vp_pc._pltout);
    c = IPAT;
    puth (c, vp_pc._pltout);

    for (ii = 0; ii < NX * NY; ii++)
    {
	c = colarray[ii];
	puth (c, vp_pc._pltout);
    }
}
