/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./lvplot/vp_hatchload.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#include <stdio.h>
#include <vplot.h>
#include "vp_pc.h"

#ifdef FORTRAN

#define HATCHLOAD vphatchload_
#define ANGLE   *angle
#define NUMHATCH    *numhatch
#define IHATCH  *ihatch

#else

#define HATCHLOAD vp_hatchload
#define ANGLE   angle
#define NUMHATCH    numhatch
#define IHATCH  ihatch

#endif

HATCHLOAD (angle, numhatch, ihatch, hatcharray)
    int             ANGLE, NUMHATCH, IHATCH;
    int            *hatcharray;
{
int             c;
int             ii;

    putc (VP_PATLOAD, vp_pc._pltout);
    c = ANGLE;
    puth (c, vp_pc._pltout);
    c = -1;
    puth (c, vp_pc._pltout);
    c = NUMHATCH;
    puth (c, vp_pc._pltout);
    c = IHATCH;
    puth (c, vp_pc._pltout);

    for (ii = 0; ii < 2 * 4 * NUMHATCH; ii++)
    {
	c = hatcharray[ii];
	if (ii % 4 > 1)
	    c *= RPERIN / HATCHPERIN;
	puth (c, vp_pc._pltout);
    }
}
