/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *  source file:   ./lvplot/vp_file.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 *
 * Steve Cole (SEP), October 27 1987
 *	Null character is added to filename when called from fortran
 *      to prevent allocation errors.
 */

#include <stdio.h>
#include <vplot.h>
#include "vp_pc.h"

#ifdef FORTRAN

#define VPFILE vpwfile_

#else

#define VPFILE vp_file

#endif

#ifdef FORTRAN
VPFILE (filename, nchars)
    int            *nchars;
#else
VPFILE (filename)
#endif
    char           *filename;
{
FILE           *temp, *fopen ();

#ifdef FORTRAN
char           *tempfilename;
char           *malloc ();
int             ncharsp1, i;
    ncharsp1 = *(nchars) + 1;
    tempfilename = (char *) malloc (ncharsp1);
    tempfilename[ncharsp1 - 1] = '\0';
    for (i = 0; i < *(nchars); i++)
    {
	tempfilename[i] = filename[i];
    }
    temp = fopen (tempfilename, "w");
#else FORTRAN
    temp = fopen (filename, "w");
#endif
    if (temp == NULL)
    {
#ifdef FORTRAN
	fprintf (stderr, "libvplot.vpfile: cannot create %s\n", tempfilename);
#else
	fprintf (stderr, "libvplot.vpfile: cannot create %s\n", filename);
#endif
	exit (-1);
    }
    vp_pc._pltout = temp;
}
