/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./lvplot/vp_clip.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 * Joe Dellinger Jan 14 1988
 *	Do rounding.
 */

#include <stdio.h>
#include <vplot.h>
#include "round.h"
#include "vp_pc.h"

#ifdef FORTRAN

#define CLIP vpclip_
#define XMIN *xmin
#define YMIN *ymin
#define XMAX *xmax
#define YMAX *ymax

#else

#define CLIP vp_clip
#define XMIN xmin
#define YMIN ymin
#define XMAX xmax
#define YMAX ymax

#endif

CLIP (xmin, ymin, xmax, ymax)
    float           XMIN, YMIN, XMAX, YMAX;
{
int             ix, iy;

    putc (VP_WINDOW, vp_pc._pltout);
    ix = ROUND (XMIN * RPERIN);
    puth (ix, vp_pc._pltout);
    iy = ROUND (YMIN * RPERIN);
    puth (iy, vp_pc._pltout);
    ix = ROUND (XMAX * RPERIN);
    puth (ix, vp_pc._pltout);
    iy = ROUND (YMAX * RPERIN);
    puth (iy, vp_pc._pltout);
}
