/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./lvplot/vp_arrow.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#include <vplot.h>
#include <math.h>
#define pio4 0.785398

#ifdef FORTRAN

#ifndef UUU
#define ARROW vparrow_
#else UUU
#define ARROW vpuarrow_
#endif UUU
#define X0	*x0
#define Y0	*y0
#define X	*x
#define Y	*y
#define R	*r

#else

#ifndef UUU
#define ARROW vp_arrow
#else UUU
#define ARROW vp_uarrow
#endif UUU
#define X0	x0
#define Y0	y0
#define X	x
#define Y	y
#define R	r

#endif

ARROW (x0, y0, x, y, r)
/*
 * plot an arrow from (x0,y0) to (x,y) with arrow-size r
 */
    float           X0, Y0, X, Y, R;
{
float           beta, alpha, xp[4], yp[4], rr;
int             flag = 0;

    if (R < 0.)
    {
	rr = -(R);
	flag = 1;
    }
    else
	rr = R;

    if (X == X0 && Y == Y0)
    {
	xp[0] = X - rr / 3.;
	yp[0] = Y - rr / 3.;
	xp[1] = X - rr / 3.;
	yp[1] = Y + rr / 3.;
	xp[2] = X + rr / 3.;
	yp[2] = Y + rr / 3.;
	xp[3] = X + rr / 3.;
	yp[3] = Y - rr / 3.;
	if (flag)
#ifndef UUU
	    vp_area (xp, yp, 4, 0, 0, 0);
#else UUU
	    vp_uarea (xp, yp, 4, 0, 0, 0);
#endif UUU
	else
#ifndef UUU
	    vp_area (xp, yp, 4, 0, 1, 1);
#else UUU
	    vp_uarea (xp, yp, 4, 0, 1, 1);
#endif UUU
    }
    else
    {
#ifndef UUU
	vp_move (X0, Y0);
	vp_draw (X, Y);
#else UUU
	vp_umove (X0, Y0);
	vp_udraw (X, Y);
#endif UUU

	beta = atan2 (Y - Y0, X - X0);

	xp[0] = X;
	yp[0] = Y;
	alpha = pio4 + beta;
	xp[1] = X - rr * cos (alpha);
	yp[1] = Y - rr * sin (alpha);
	alpha = pio4 - beta;
	xp[2] = X - rr * cos (alpha);
	yp[2] = Y + rr * sin (alpha);
	if (flag)
#ifndef UUU
	    vp_area (xp, yp, 3, 0, 0, 0);
#else UUU
	    vp_uarea (xp, yp, 3, 0, 0, 0);
#endif UUU
	else
#ifndef UUU
	    vp_area (xp, yp, 3, 0, 1, 1);
#else UUU
	    vp_uarea (xp, yp, 3, 0, 1, 1);
#endif UUU
    }
}
