/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/sample.c
 *
 * Joe Dellinger (SEP), Feb 19 1988
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#include <stdio.h>
/*
 * Things we have to include
 */
#include "./include/closestat.h"
#include "./include/extern.h"

/*
 * These make init_vplot happy
 */
extern char callname[];
extern FILE *pltout;
int xargc;
char **xargv;

/*
 * These make dovplot happy
 */
extern FILE *pltin;
extern char pltname[];

main(argc,argv)
int argc;
char **argv;
{
/*
 * Copy these across so getpar has something to work with.
 */
xargc  = argc;
xargv = argv;

/*
 * Throw in dummy names just so there's something there.
 */
strcpy (callname, "default");
strcpy (pltname, "Sample");

/*
 * Set up pltin and pltout
 */
pltout = stdout;
pltin = stdin;

/*
 * Initialize everything
 */
init_vplot();

/*
 * Do the plot
 */
dovplot();

/*
 * Close the device
 */
dev.close (CLOSE_NORMAL);
dev.close (CLOSE_DONE);

/*
 * The problem, of course, is that bypassing all the other routines
 * we may be overlooking possibly vital things such as did the device
 * need an "ERASE_END", can it use piped input, did it need the
 * text screen turned back on, etc, etc.
 * We also neglect to turn echoing and output translation back on
 * (if it was turned off), etc, etc. Probably better to at least use
 * proc_vplot, or to start by making a copy of it.
 * But, for a specific device with known requirements this
 * simple example shows how to use the power of dovplot without having to
 * throw in the kitchen sink, too.
 */
}
