/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/main_vplot.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

/*
 * generic pen -  VPLOT filter for whatever
 * Keyword: graphics vplot pen
 */

/*
 *  Edit History
 *
 *  "Pen" written 1979 for a PDP-11, Rob Clayton
 *  Eventually modified into "tekpen" by Glenn Kroeger early 1984
 *  Made device independent and extensively modified into "screenpen"
 *  by Joe Dellinger 1984 through 1985
 *  Reworked to be more GKS-like by Glenn and Michel Debiche, 1985
 *  Cleaned up, Joe 1986
 *  Added 'wstype' variable so one program can support multiple
 *		terminal types		-- Chuck Karish, Nov 1986
 *  Raster capability added -- Joe and Steve Cole 1987
 *  Cleaned up and documented for public release, Joe Dellinger 1987
 *  Whew!
 *
 *  Changed system("stty ...") calls to ioctls.  The system() calls
 *  are hanging for jon under 6.0.  Added sigblock() to cleanup
 *  error handler to avoid exit() problems.  Also shut down output
 *  translations to tty graphics terminals.  Stewart A. Levin  6-23-87
 *
 *  Shut down output translations with LLITOUT now that I've gotten
 *  the magic incantation that makes it stick on buggy BSD systems.
 *  Stewart A. Levin  7-5-87
 *
 *  Made "scale" a global so dovplot could use it.
 *  Joe Dellinger Oct 18 1987
 *
 *  Gather up all the incoming plot files, and then have "genreader"
 *  process them all. This allows someone to make a vplot-editor that
 *  can re-order plot files, repeat them, etc, etc. Added "buffer_input"
 *  and "allow_pipe" as part of this.
 *  Joe Dellinger Dec 16 1987
 *
 *  Added "hclose_done" to SEPlib version.
 *  Joe Dellinger Dec 19 1987
 *
 *  Added "reset_parameters" to frontend and dovplot
 *  Joe Dellinger Jan 8 1988
 *
 *  Added group_name, group_number, pltname
 *  Joe Dellinger Jan 20 1988
 *
 *  Inverted window should mean that everything gets clipped.
 *  Make it possible to override standard defaults for SEP.
 *  Joe Dellinger Feb 12 1988
 *
 *  Just use getpar, not getpar_.
 *  Joe Dellinger Feb 16 1988
 *
 *  Split "frontend.c" into 3 files,
 *  main_vplot, init_vplot, and proc_vplot.
 *  This so that other programs can use vplot and still keep their own
 *  mains.
 *  Joe Dellinger Feb 18 1988
 */

#ifdef SEP
extern void     sepwhere ();
extern char     sepoutwhere[];
extern char     sepheadwhere[];

#define		OUT	sepoutwhere
#define		HEAD	sepheadwhere
#define		SOURCE  "\014Joe Dellinger, Stanford Exploration Project\014"
#include	<sep.main>
#define		GETPAR	fetch

#else SEP
#include	<stdio.h>
#include	<math.h>
#define		GETPAR	getpar
#endif SEP


#include	<sys/ioctl.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<sgtty.h>
#include	<ctype.h>
#include	<strings.h>
#include	<signal.h>

#include	<vplot.h>

#include	"./include/params.h"	/* for machine dependencies */
#include	"./include/enum.h"
#include	"./include/err.h"
#include	"./include/attrcom.h"
#include	"./include/intcom.h"
#include	"./include/mesgcom.h"
#include	"./include/erasecom.h"
#include	"./include/closestat.h"
#include	"./include/pat.h"
#include	"./include/vertex.h"
#include	"./include/round.h"
#include	"./include/extern.h"


/*
 * signal catching
 */
int             cleanup ();
int             sigvec ();
int             signum[] =
{
 SIGHUP, SIGINT, SIGQUIT, SIGIOT, SIGEMT, SIGPIPE, SIGTERM, SIGXCPU, SIGXFSZ
};
#define NOSIG (sizeof (signum)/sizeof (int))	/* number of signals caught */
struct sigvec   errhandler =
{
 cleanup, 0, 0
};
struct sigvec   ignored =
{
 SIG_IGN, 0, 0
};
struct sigvec   oldvec;

extern struct sgttyb tty_clean_state;	/* external for utilities */
extern int      tty_clean_local_mode;
extern int      allow_pipe;
extern char     callname[];
extern int      nplots;
extern int      allowecho;

/*
 * file and terminal control variables
 */
extern int      genmessage ();
extern int      (*message) ();
extern FILE    *pltout;

FILE           *fopen ();
FILE           *fdopen ();

extern FILE    *pltinarray[MAXIN];
extern char     pltinname[MAXIN][MAXFLEN + 1];
extern int      infileno;
extern int      pltoutfd;

/*
 * This routine is responsible for finding the input files,
 * setting up the input and output, and calling init_vplot
 * and proc_vplot. You can link to vplot without using this
 * routine, and so have your own main. See vplothacker.doc to
 * learn how to do this. (Especially you, Jon!)
 */

#ifdef SEP
int             xxargc;
char          **xxargv;
char            scrap[MAXFLEN + 1];
int             hclose_done = NO;
int             fake_header = NO;
MAIN ()

#else SEP
int             xargc;
char          **xargv;	/* for getpar */
main (argc, argv)
    int             argc;
    char           *argv[];
#endif SEP
{
#ifndef SEP
int             in_isatty, num_vplot, docflag;
char            instring[MAXFLEN + 1];
#endif SEP

char           *cptr;
char           *stringptr;
int             ii;
FILE           *temp;
char            string[MAXFLEN + 1];


    nulldev ();			/* Just to make sure it gets loaded */

#ifndef SEP
    if (stringptr = rindex (argv[0], '/'))
	strncpy (callname, ++stringptr, 24);
    else
	strncpy (callname, argv[0], 24);
#else SEP
    if (stringptr = rindex (xargv[0], '/'))
	strncpy (callname, ++stringptr, 24);
    else
	strncpy (callname, xargv[0], 24);
#endif SEP

#ifdef SEP
    pltout = outstream;
    if (redout ())
    {
	getch ("head", "s", scrap);
	if (strcmp (scrap, "/dev/null") == 0 &&
	    strcmp (sepheadwhere, "/dev/null") == 0)
	{
	    fake_header = YES;
	    getch ("out", "s", scrap);
	    if (strcmp (scrap, "stdout") != 0)
	    {
		/*
		 * They probably want the header output into the redirected
		 * output. (SEP only) 
		 */
		headstream = stdout;
		headfd = fileno (headstream);
		Puthead ("Fake header for special device-dependent data only.\n");
		Puthead ("To get input history passed along, over-ride default with head = stdout\n");
		/*
		 * If the output is going into a file, then put this
		 * information into the header file. 
		 */
		if (strcmp (scrap, "/dev/tty") != 0)
		{
		    fullnm (scrap, MAXFLEN + 1);
		    Puthead ("\tin=%s\n", scrap);
		}
		else
		{
		    Puthead ("\tin= nowhere\n");
		    Puthead ("\t(Sorry, the data went to the terminal; it's gone now!)\n");
		}

		/*
		 * Have to use my own puthead routine. Standard ones such as
		 * putch, etc, don't work with this. They remember where the
		 * header used to be. Puthead does this, checking for
		 * headstream not null. This is so this will work without
		 * sep, as well. 
		 */
	    }
	}
    }

    if (!fake_header)
    {
	Puthead ("\tn3 = unknown\n\t(Sorry, SEPlib requires the header be closed now)\n");
	hclose ();
	hclose_done = YES;
    }
#else SEP

    /*
     * If no arguments, and not in a pipeline, self document "wstype="
     * doesn't count as an argument for our purposes 
     */
    in_isatty = isatty ((int) (fileno (stdin)));
    xargc = argc;
    xargv = argv;
    docflag = 0;
    if (argc == 1)
	docflag = 1;
    if ((argc == 2) && !strncmp ("wstype=", argv[1], 7))
	docflag = 1;
    getpar ("selfdoc", "1", &docflag);
    if (in_isatty && docflag)
    {
	for (ii = 0; ii < doclength; ii++)
	    printf ("%s\n", documentation[ii]);
	exit (0);
    }

    pltout = stdout;
#endif SEP

    /*
     * This getpar for signal is only included for debugging purposes. By
     * using a signal option, one can stop any signals from being caught. 
     */
    if (getpar ("signal", "s", string) == 0)
    {
	for (ii = 0; ii < NOSIG; ++ii)
	{
	    if (-1 == sigvec (signum[ii], &ignored, &oldvec))
	    {
		ERR (FATAL, name, "Bad sigvec call!");
	    }
	    if (oldvec.sv_handler == ignored.sv_handler)
		(void) sigvec (signum[ii], &oldvec, (struct sigvec *) NULL);
	    else
		(void) sigvec (signum[ii], &errhandler, (struct sigvec *) NULL);
	}
    }

/*
 ****************************************************************************
 * Set all global variables, open the device.
 ****************************************************************************
 */
    init_vplot ();

/*
 ****************************************************************************
 * Start processing input files
 ****************************************************************************
 */

#ifdef SEP
    if (instream != NULL)
    {
	if (!allow_pipe && isapipe (fileno (instream)))
	{
	    ERR (WARN, name, "cannot use pipes with this device");
	}
	else
	{
	    if (infileno >= MAXIN)
	    {
		ERR (FATAL, name, "too many input files (%d max)", MAXIN);
	    }
	    strcpy (pltinname[infileno], "Pipe");
	    pltinarray[infileno] = instream;
	    infileno++;
	}
    }
    else
	ERR (WARN, name, "cannot read input pipe");

    xxargc = xargc;
    xxargv = xargv;

    for (xxargc--, xxargv++; xxargc; xxargc--, xxargv++)
    {
	cptr = *xxargv;
	while (*cptr)
	{
	    if (*cptr == '=')
		break;
	    cptr++;
	}
	if (*cptr)
	    continue;
	/* Ignore dummy arguments */
	if (strcmp (*xxargv, "dummy") == 0)
	    continue;
	if ((temp = fopen (*xxargv, "r")) == NULL)
	{
	    ERR (WARN, name, "cannot open header file %s", *xxargv);
	    continue;
	}
	fclose (temp);
	if (getch2 ("in", "s", string, *xxargv))
	{
	    if ((temp = fopen (string, "r")) != NULL)
	    {
		Puthead ("   +  %s --> in = %s\n", *xxargv, string);
		if (infileno >= MAXIN)
		{
		    ERR (FATAL, name, "too many input files (%d max)", MAXIN);
		}
		strcpy (pltinname[infileno], string);
		pltinarray[infileno] = temp;
		infileno++;
	    }
	    else
	    {
		ERR (WARN, name, "cannot open input file %s", string);
	    }
	}
    }

#else SEP
    /*
     * first process pipe input 
     */
    if (!in_isatty)
    {
	if (!allow_pipe)
	{
	    ERR (WARN, name, "cannot use pipes with this device");
	}
	else
	{
	    if (infileno >= MAXIN)
	    {
		ERR (FATAL, name, "too many input files (%d max)", MAXIN);
	    }
	    strcpy (pltinname[infileno], "stdin");
	    pltinarray[infileno] = stdin;
	    infileno++;
	}
    }

    /*
     * next process in= inputfiles If they set num_vplot, also look for in1=
     * in2= etc 
     */

    num_vplot = 0;
    getpar ("numvplot", "d", &num_vplot);

    for (ii = 0; ii <= num_vplot; ii++)
    {
	if (ii == 0)
	    strcpy (instring, "in");
	else
	    sprintf (instring, "in%d", ii);

	if (getpar (instring, "s", string))
	{
	    if ((temp = fopen (string, "r")) != NULL)
	    {
		if (infileno >= MAXIN)
		{
		    ERR (FATAL, name, "too many input files (%d max)", MAXIN);
		}
		strcpy (pltinname[infileno], string);
		pltinarray[infileno] = temp;
		infileno++;
	    }
	    else
	    {
		ERR (WARN, name, "cannot open %s", string);
	    }
	}
    }

    /*
     * finally process input line for non-getpar arguments and assume they
     * are also input files 
     */
    for (argc--, argv++; argc; argc--, argv++)
    {
	cptr = *argv;
	while (*cptr)
	{
	    if (*cptr == '=')
		break;
	    cptr++;
	}
	if (*cptr)
	    continue;
	cptr = *argv;
	if ((temp = fopen (cptr, "r")) != NULL)
	{
	    if (infileno >= MAXIN)
	    {
		ERR (FATAL, name, "too many input files (%d max)", MAXIN);
	    }
	    strcpy (pltinname[infileno], cptr);
	    pltinarray[infileno] = temp;
	    infileno++;
	}
	else
	{
	    ERR (WARN, name, "cannot open %s", cptr);
	}
    }
#endif SEP

/*
 ****************************************************************************
 * Go do the plots
 ****************************************************************************
 */
    proc_vplot ();

#ifdef SEP
    if (!hclose_done)
    {
	Puthead ("\tn3=%d\n", nplots);
	hclose ();
	hclose_done = YES;
    }
#endif SEP

    exit (0);
}

cleanup ()
{
    sigblock (~(SIGKILL | SIGSTOP | SIGCONT));
    dev.close (CLOSE_INTERRUPT);
    message (MESG_ON);
    ERR (COMMENT, name, "Interrupted out.");
    dev.close (CLOSE_DONE);
    /*
     * Let them see what they are doing again 
     */
    if (!allowecho)
    {
	ioctl (pltoutfd, TIOCLSET, (char *) (&tty_clean_local_mode));
	ioctl (pltoutfd, TIOCSETN, (char *) (&tty_clean_state));
    }
    exit (0);
}
