/*
 *
 *  source file:   ./filters/loclib/Puthead.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 *
 * Joe Dellinger Dec 19 1987
 *	Added check for hclose_done; Don't write to header if we've
 *	closed the history part.
 */

/*
 *	The standard version of puthead will barf if the header
 *	is closed or if headstream has been changed from the last call.
 *	We need it to be tolerant of these inconsistencies.
 */

#include    <stdio.h>
#define MIXED    union { char *s; int *i; float *f; double *g; }

extern int      hclose_done;

/*
 *	put a line on the header.
 *	the arguments are identical to printf conventions, except 
 *		there is a maximum of nine
 */

Puthead (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)
    char           *a, *b, *c, *d, *e, *f, *g, *h, *i, *j, *k, *l, *m, *n, *o, *p;
{
FILE           *file;
extern FILE    *headstream;
    if (headstream == NULL || hclose_done)
	return;
    fprintf (headstream, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
    fflush (headstream);
}
