#
# Here is the csh to use to assemble the Hershey font data into reasonable,
# useable fonts for use with Vplot. The lines_normal_* files contain the
# information such as base height and ligatures that hertovplot.c mentions
# needs to be edited in "by hand". (Note all the ligatures for the Russian
# font! This follows the standard method for transliterating Cyrillic into
# the roman alphabet.)
#
# It's up to you to get the required .oc files from the
# Hershey font distribution.
# I'm not going to redistribute the fonts again!
#
# I do, however, give you .hmp files. Mine are somewhat modified
# from the ones that come with the original Hershey font distribution.
# Mine correct mistakes in and improve on the original ones.
#
# Joe Dellinger
# joe@hanauma.stanford.edu
#
cat hersh.oc1 hersh.oc2 hersh.oc3 hersh.oc4 > HERSH
cc -o hertovplot hertovplot.c

# Normal Size fonts
# Beware! Roman triplex font has an error in character "J"!
# (Width information has a sign error.)
# You have to fix this by hand before installing it!
# I've commented that file out for now.
foreach file ( gothgbt.hmp gothgrt.hmp gothitt.hmp greekc.hmp greeks.hmp italict.hmp romand.hmp romans.hmp ) #romant.hmp
echo $file
hertovplot $file < HERSH > temp
cat lines_normal temp > $file:r.vplot_font
rm -f temp
end
foreach file ( italicc.hmp romanc.hmp )
echo $file
hertovplot $file < HERSH > temp
cat lines_normal+rolig temp > $file:r.vplot_font
rm -f temp
end
foreach file ( cyrilc.hmp )
echo $file
hertovplot $file < HERSH > temp
cat lines_normal+cylig temp > $file:r.vplot_font
rm -f temp
end

# Script Normal (No spaces between characters)
foreach file ( scriptc.hmp scripts.hmp )
echo $file
hertovplot $file < HERSH > temp
cat lines_normal_script temp > $file:r.vplot_font
rm -f temp
end

# Misc Normal
foreach file ( math.hmp misc.hmp )
echo $file
hertovplot $file < HERSH > temp
cat lines_normal_misc temp > $file:r.vplot_font
rm -f temp
end

rm -f HERSH hertovplot
# Now copy all the newly generated vplot_fonts to the vplotfont directory.
mv *.vplot_font ../filters/include/vplotfonts
