/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/vplib/vpopen.c
 *
 * Joe Dellinger (SEP), Dec 19 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#include <stdio.h>
#include <vplot.h>
#include "../include/enum.h"
#include "../include/extern.h"
#include "../include/err.h"
#include "../include/params.h"
#include "vp.h"

extern int
vpopen (), vpreset (), vpmessage (), vperase (), vpclose ();
extern int
vpattributes (), vpvector (), vpplot ();
extern int
vpstartpoly (), vpmidpoly (), vpendpoly ();
extern int
vpraster (), vpmarker (), vptext ();
extern int
genarea (), genpoint ();
extern int      nulldev ();

extern FILE    *pltout;

extern int      vp_do_dovplot ();
extern int      (*genreader) ();
extern int      allow_pipe;
extern int      first_time;

int             vpbig = YES;
int             vpdumb = NO;
int             vpstat = NO;
int             vpalign = NO;
int             vpstyle = YES;
int             vpblast = YES;
int             vpbit = 0;
char            vpaligns[80] = "uu";
int             vparray[2] = {0, 0};
int             vpasize[2] = {0, 0};
int             vpframe = -1;

int             vpsetflag;

vpopen ()
{
float           atemp[2];

    first_time = YES;

/*
 * Special options
 */
    getpar ("dumb", "1", &vpdumb);
    getpar ("blast", "1", &vpblast);
    getpar ("bit", "d", &vpbit);
    getpar ("grid", "d", &vpframe);

    getpar ("stat", "1", &vpstat);
    getpar ("align", "s", vpaligns);

    if (vpstat || strcmp (vpaligns, "uu") != 0)
    {
	vpalign = YES;
	allow_pipe = NO;
    }

    getpar ("gridnum", "d", vparray);

    if (vparray[1] == 0)
	vparray[1] = vparray[0];

    if (vparray[0] != 0)
    {
	vpbig = NO;
	vpstyle = NO;
    }

    getpar ("big", "1", &vpbig);
    getpar ("vpstyle", "1", &vpstyle);

    if (vparray[0] != 0)
    {
	if (vpbig || vpalign)
	    ERR (FATAL, name, "Incompatible option with gridnum");
	atemp[0] = (float) (STANDARD_HEIGHT / SCREEN_RATIO) / vparray[0];
	atemp[1] = (float) (STANDARD_HEIGHT) / vparray[1];

	getpar ("gridsize", "f", atemp);

	vpasize[0] = atemp[0] * RPERIN;
	vpasize[1] = atemp[1] * RPERIN;
    }


/*
 * We want to go through the input files ourselves
 */

    genreader = vp_do_dovplot;

/*
 * device capabilities
 */

    if (vpbig)
    {
	dev_xmax = VP_MAX * RPERIN;
	dev_ymax = VP_MAX * RPERIN * SCREEN_RATIO;
	dev_xmin = -dev_xmax;
	dev_ymin = -dev_ymax;
	default_hshift = -dev_xmin;
	default_vshift = -dev_ymin;
    }
    else
    {
	dev_xmax = STANDARD_HEIGHT * RPERIN / SCREEN_RATIO;
	dev_ymax = STANDARD_HEIGHT * RPERIN;
	dev_xmin = 0;
	dev_ymin = 0;
	default_hshift = 0;
	default_vshift = 0;
    }

    pixels_per_inch = RPERIN;
    aspect_ratio = 1.;
    num_col = 256;
    if (vparray[0] == 0)
	size = ABSOLUTE;


/*
 * Since font gets hard-wired in after first pass,
 * make it a nice one if they don't specify it.
 */
    txfont = DEFAULT_HARDCOPY_FONT;
    txprec = DEFAULT_HARDCOPY_PREC;

/*
 * Make vplib routines more useful to be included in other programs
 * besides just vppen
 */
    dev.open = vpopen;
    dev.reset = vpreset;
    dev.message = vpmessage;
    dev.erase = vperase;
    dev.close = vpclose;
    dev.vector = vpvector;
    dev.marker = vpmarker;
    dev.text = vptext;
    dev.area = genarea;
    dev.raster = vpraster;
    dev.point = genpoint;
    dev.attributes = vpattributes;
    dev.getpoint = nulldev;
    dev.interact = nulldev;
    dev.plot = vpplot;
    dev.startpoly = vpstartpoly;
    dev.midpoly = vpmidpoly;
    dev.endpoly = vpendpoly;

/*
 * To keep messages from being lost
 */
    message = dev.message;

/*
 * Open up the "device", if we're ever going to use libvplot at all.
 */
    if (!vpstat)
    {
	vp_filep (pltout);
    }

    allowecho = YES;

}
