/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/vplib/vpdovplot.c
 *
 * Joe Dellinger (SEP), Jan 9 1988
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#include <stdio.h>
#include <vplot.h>
#include "../include/enum.h"
#include "../include/extern.h"
#include "../include/params.h"
#include "../include/err.h"
#include "vp.h"

extern FILE    *pltout;
extern int      first_time;
extern int      style;
extern int      default_style;

extern int
vecarea (), genmarker (), gentext (), genraster ();
extern int
genmessage (), genvector (), vp_do_dovplot (), nulldev ();
extern int
vplogvector (), vplogmessage ();
extern int      (*genreader) ();

extern int
vpopen (), vpreset (), vpmessage (), vperase (), vpclose ();
extern int
vpattributes (), vpvector (), vpplot ();
extern int
vpstartpoly (), vpmidpoly (), vpendpoly ();
extern int
vpraster (), vpmarker (), vptext ();
extern int
genarea (), genpoint ();

int             vpxmax, vpxmin, vpymax, vpymin;
static int      vpxmaxs, vpxmins, vpymaxs, vpymins;

vp_do_dovplot (nn, inpltin, innames)
    int             nn;
    FILE          **inpltin;
    char            innames[][MAXFLEN + 1];
{
int             ii;
int             save_wantras;
int             save_shade;
char            string[80];
static int      it_got_clipped;
float           hh, ww;

    if (nn == 0)
	return;

/*
 * If they want statistics, make one "dummy" pass through first
 * before you really do it.
 */
    if (vpalign)
    {
	/*
	 * Turn on automatic processing 
	 */
	smart_clip = NO;
	smart_raster = NO;

	/*
	 * Just outline polygons and raster with vectors 
	 */
	save_wantras = wantras;
	save_shade = shade;

	wantras = NO;
	shade = NO;

	/*
	 * Turn off any actual output 
	 */
	dev.reset = nulldev;
	dev.message = vplogmessage;
	message = dev.message;
	dev.erase = nulldev;
	dev.close = nulldev;
	dev.vector = vplogvector;
	dev.marker = genmarker;
	dev.text = gentext;
	dev.area = nulldev;
	dev.raster = nulldev;
	dev.point = genpoint;
	dev.attributes = nulldev;

/*
 * Now do the trial pass
 */

	vpxmaxs = dev_xmin;
	vpxmins = dev_xmax;
	vpymaxs = dev_ymin;
	vpymins = dev_ymax;

	it_got_clipped = NO;

	for (ii = 0; ii < nn; ii++)
	{
	    vpxmax = dev_xmin;
	    vpxmin = dev_xmax;
	    vpymax = dev_ymin;
	    vpymin = dev_ymax;

	    pltin = inpltin[ii];
	    strcpy (pltname, innames[ii]);
	    dovplot ();
	    rewind (pltin);

	    if (vpxmaxs < vpxmax)
		vpxmaxs = vpxmax;
	    if (vpymaxs < vpymax)
		vpymaxs = vpymax;
	    if (vpxmins > vpxmin)
		vpxmins = vpxmin;
	    if (vpymins > vpymin)
		vpymins = vpymin;

	    if (vpstat)
	    {
		hh = (float) (vpymax - vpymin) / RPERIN;
		ww = (float) (vpxmax - vpxmin) / RPERIN;

		if (hh < 0. || ww < 0.)
		{
		    fprintf (pltout,
			     "%17s: clipped away. ",
			     innames[ii]);
		}
		else
		{
		    fprintf (pltout,
			     "%17s: h=%6.2f w=%6.2f;  x=(%6.2f,%6.2f) y=(%6.2f,%6.2f) ",
			     innames[ii],
			     hh, ww,
			     (float) vpxmin / RPERIN,
			     (float) vpxmax / RPERIN,
			     (float) vpymin / RPERIN,
			     (float) vpymax / RPERIN);
		}

		if (vpxmax == dev_xmin || vpxmax == dev_xmax ||
		    vpxmin == dev_xmax || vpxmin == dev_xmin ||
		    vpymax == dev_ymin || vpymax == dev_ymax ||
		    vpymin == dev_ymax || vpymin == dev_ymin)
		{
		    fprintf (pltout, "*\n");
		    it_got_clipped = YES;
		}
		else
		{
		    fprintf (pltout, "\n");
		}
	    }
	}

	if (vpstat && nn > 1)
	{
	    sprintf (string, "All %d", nn);
	    fprintf (pltout,
		"%17s: h=%6.2f w=%6.2f;  x=(%6.2f,%6.2f) y=(%6.2f,%6.2f)\n",
		     string,
		     (float) (vpymaxs - vpymins) / RPERIN,
		     (float) (vpxmaxs - vpxmins) / RPERIN,
		     (float) vpxmins / RPERIN,
		     (float) vpxmaxs / RPERIN,
		     (float) vpymins / RPERIN,
		     (float) vpymaxs / RPERIN);
	}

	if (vpstat)
	{
	    if (it_got_clipped)
	    {
		if (vpbig)
		{
		    fprintf (pltout,
			 "\nA * indicates a plot that has been clipped.\n");
		    fprintf (pltout,
			     "Remember rotated style plots go to the top of the screen,\n");
		    fprintf (pltout,
			     "which is infinitely far away if big=y.\n");
		}
		else
		{
		    fprintf (pltout,
		    "\nA * indicates a plot that has been clipped at the\n");
		    fprintf (pltout,
		     "virtual screen boundaries. You may not want this.\n");
		    fprintf (pltout,
		    "This clipping can be disabled by the big=y option.\n");
		}
	    }

	    for (ii = 0; ii < nn; ii++)
	    {
		pltin = inpltin[ii];
		fclose (pltin);
	    }
	    return;
/*
 * Statistics get changed by re-aligning anyways,
 * So might as well just exit.
 */
	}

	switch (vpaligns[0])
	{
	case 'l':
	    default_hshift += (0 - vpxmins);
	    break;
	case 'r':
	    default_hshift += (0 - vpxmaxs);
	    break;
	case 'c':
	    default_hshift += (0 - ((vpxmaxs + vpxmins) / 2));
	    break;
	case 'u':
	    break;
	default:
	    ERR (WARN, name, "Unknown left-right alignment type %c.",
		 vpaligns[0]);
	    break;
	}

	switch (vpaligns[1])
	{
	case 'b':
	    default_vshift += (0 - vpymins);
	    break;
	case 't':
	    default_vshift += (0 - vpymaxs);
	    break;
	case 'c':
	    default_vshift += (0 - ((vpymaxs + vpymins) / 2));
	    break;
	case 'u':
	    break;
	default:
	    ERR (WARN, name, "Unknown top-bottom alignment type %c.",
		 vpaligns[1]);
	    break;
	}

	style = default_style;

	reset_parameters ();

	/*
	 * Lie to dovplot, tell it to start from scratch again 
	 */
	first_time = YES;

	/*
	 * Undo the damage from the first pass 
	 */
	wantras = save_wantras;
	shade = save_shade;

	dev.reset = vpreset;
	dev.message = vpmessage;
	message = dev.message;
	dev.erase = vperase;
	dev.close = vpclose;
	dev.vector = vpvector;
	dev.marker = vpmarker;
	dev.text = vptext;
	dev.area = genarea;
	dev.raster = vpraster;
	dev.point = genpoint;
	dev.attributes = vpattributes;
    }

/*
 *********************************************************************
 * "Real" pass
 *********************************************************************
 */

    if (vpdumb)
    {
	dev.message = genmessage;
	dev.vector = genvector;
	dev.marker = genmarker;
	dev.text = gentext;
	dev.area = vecarea;
	dev.raster = genraster;
	smart_clip = NO;
	smart_raster = NO;
    }
    else
    {
	smart_clip = YES;
	smart_raster = YES;
    }

/* Second (or first) pass */
    for (ii = 0; ii < nn; ii++)
    {
	pltin = inpltin[ii];
	strcpy (pltname, innames[ii]);
	dovplot ();
	fclose (pltin);
    }
}
