/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/raslib/rasopen.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#include <stdio.h>
#include "../include/enum.h"
#include "../include/extern.h"
#include "../include/err.h"
#include <strings.h>
#ifdef SEP
#include <ctype.h>
#endif
#define DEFAULT_OUT	isatty(fileno(pltout))
#include "raspen.h"

char           *image;
extern char    *malloc ();
extern float    aspect_ratio;
extern float    pixels_per_inch;
int             color_mult, rasor = 0;
char            colfile[60];

extern int      num_col;
extern int      rasvector2 ();

rasopen ()
{
extern char   **xargv;
extern FILE    *pltout;
extern char    *alloc ();
#ifdef SEP
extern int      headfd;
char            headname[30], fname[80];
char            path[50];
char           *front, *tail, *ptr;
#endif
char            newpath[60];

/*
 * physical device parameters
 */
    dev_xmax = 100;
    dev_ymax = 100;
    dev_xmin = 0;
    dev_ymin = 0;
    pixels_per_inch = 100.;
    aspect_ratio = 1.;

/*
 * device capabilities
 */
    need_end_erase = YES;
    buffer_output = YES;
    smart_clip = NO;

    color_mult = 2;
    getpar ("colormult", "d", &color_mult);
    num_col = NCOLOR / color_mult;

    getpar ("or", "1", &rasor);
    if (rasor)
    {
	dev.vector = rasvector2;
    }

    dev_xmax = 1024;
    dev_ymax = 768;
    aspect_ratio = 1.;
    getpar ("n1", "d", &dev_xmax);
    getpar ("n2", "d", &dev_ymax);
    getpar ("aspect", "f", &aspect_ratio);
    pixels_per_inch /= ((float) 768 / (float) dev_ymax);
    getpar ("ppi", "d", &pixels_per_inch);
#ifdef SEP
    Puthead ("\n\n# Raspen: VPLOT graphics via Movie,\n");
    Puthead ("#\tor any other byte-deep raster device.\n\n");
    Puthead ("\taspect_ratio=%f\n", aspect_ratio);
    Puthead ("\tesize=1\n");
    Puthead ("\tn1=%d\n", dev_xmax);
    Puthead ("\tn2=%d\n", dev_ymax);
#endif


    /*
     * Allocate space for image 
     */
    if ((image = malloc (dev_xmax * dev_ymax)) == NULL)
    {
	ERR (FATAL, name, "Can't allocate space for raster image\n");
    }

    if (DEFAULT_OUT)
    {
#ifdef SEP
	datapath (path);
/* Code stolen from output.c to get a reasonable raster file name. */
	if (0 < findnm (headfd, headname, sizeof (headname)))
	{
	    /* modify slightly */
	    strcpy (fname, "");
	    front = rindex (headname, '/');
	    if (front == ((char *) NULL))
		front = headname;
	    else
		front++;
	    if ((*front) == 'H')
		strcat (fname, ++front);
	    else
	    {
		tail = rindex (front, '.');
		if (tail == ((char *) NULL))
		    strcat (fname, front);
		else
		{
		    for (ptr = tail + 1; *ptr; ptr++)
			if (!isupper (*ptr))
			    break;
		    if (!(*ptr))/* drop suffix if all caps */
			*tail = '\0';
		    (void) strcat (fname, front);
		}
	    }
	    (void) strcat (fname, ".raster");
	}
	else
	{
	    strcpy (fname, "raster");
	}

	sprintf (newpath, "%s%s", path, fname);
	Puthead ("\tin=%s\n", newpath);
#else
	sprintf (newpath, "%s", "raster_file");
#endif
	pltout = fopen (newpath, "w");
	if (pltout == NULL)
	    ERR (FATAL, name, "can't open file %s\n", newpath);

	strcpy (colfile, "colfile");
	getpar (colfile, "s", colfile);
#ifdef SEP
	Puthead ("\tcolfile=%s\n", colfile);
	Puthead ("\tcolor=T\n");
	if (color_mult == 1)
	    Puthead ("\tumask=255\n");
#endif
    }
}
