/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/raslib/raserase.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

/*
 * Erase the graphics area
 */
#include	<stdio.h>
#include	"../include/erasecom.h"
#include	"../include/enum.h"
#include	"../include/err.h"
#include	"../include/extern.h"
#include "raspen.h"
extern FILE    *pltout;
extern int      zap ();

raserase (command)
    int             command;
{

    switch (command)
    {
    case ERASE_START:
    default:
	break;
    case ERASE_MIDDLE:
    case ERASE_END:
/*
 * Output raster file, and then CLEAR it out (erase)
 */
	if (write (fileno (pltout), image, dev_xmax * dev_ymax) != dev_xmax * dev_ymax)
	{
	    ERR (FATAL, name, "Can't write raster image\n");
	}
	zap ();
	break;
    case ERASE_BREAK:
/*
 * Output raster file, but don't CLEAR it!
 */
	if (write (fileno (pltout), image, dev_xmax * dev_ymax) != dev_xmax * dev_ymax)
	{
	    ERR (FATAL, name, "Can't write raster image\n");
	}
	break;
    }
}
