/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/raslib/rasattr.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

/*
 * control graphics attributes
 */
#include <stdio.h>
#include "../include/attrcom.h"
#include "raspen.h"
extern FILE    *pltout;
extern int      color_mult;

int             color_table[NCOLOR][3], rascolor;

rasattr (command, value, v1, v2, v3)
    register int    command, value;
    int             v1, v2, v3;
{
    switch (command)
    {
    case SET_COLOR:
	rascolor = color_mult * value;
	break;
    case SET_COLOR_TABLE:
	color_table[value * color_mult][0] = v1;
	color_table[value * color_mult][1] = v2;
	color_table[value * color_mult][2] = v3;
	break;
    default:
	break;
    }

    return 0;
}
