/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/teklib/tekpack.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#include <stdio.h>
#include "tek.h"
extern FILE    *pltout;

/*
 * Tek x,y coordinate packing.
 * Previously-encoded positions are saved in
 * ohiy, oloy, etc. in order to abbreviate the number of
 * bytes sent out. This routine assumes pltout is open.
 */
tekxypack (x, y)
    int             x, y;
{
register int    hiy, loy, hix, lox;
static int      ohiy, oloy, ohix, olox;

    /*
     * Encode the new position. 
     */
    hiy = 0040 | ((y >> 5) & 037);
    loy = 0140 | (y & 037);
    hix = 0040 | ((x >> 5) & 037);
    lox = 0100 | (x & 037);

    /*
     * Only print what's necessary, according to Tek rules. 
     */
    if (hiy != ohiy || lost == 1)
	putc (hiy, pltout);
    if (loy != oloy || hix != ohix || lost == 1)
	putc (loy, pltout);
    if (hix != ohix || lost == 1)
	putc (hix, pltout);
    if (hiy != ohiy || loy != oloy || hix != ohix || lox != olox || lost == 1)
	putc (lox, pltout);

    /*
     * Remember these for next time. 
     */
    ohiy = hiy;
    oloy = loy;
    ohix = hix;
    olox = lox;
}

/*
 * Issue a packed integer. From one to three bytes sent.
 */
tekipack (i)
    register int    i;
{
register int    ihi, imd, ilo;

    if (i < 0)
    {
	i = -i;
	ilo = 040;
    }
    else
	ilo = 060;

    ihi = 0100 | ((i >> 10) & 037);
    imd = 0100 | ((i >> 4) & 077);
    ilo |= (i & 017);

    if (ihi != 0100)
	putc (ihi, pltout);
    if (imd != 0100)
	putc (imd, pltout);
    putc (ilo, pltout);
}
