/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/teklib/tekclose.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

/*
 * Routine to close the device
 */
#include <stdio.h>
#include <strings.h>
#include "tek.h"
#include "../include/mesgcom.h"
#include "../include/closestat.h"
#include "../include/extern.h"

extern char     wstype[];

tekclose (status)
    int             status;
{
    switch (status)
    {
    case CLOSE_DONE:
	if (!strncmp (wstype, "tek401", 6))
	    message (MESG_READY);
	setmode (ALPHA);
	/* put terminal back into transparent mode */
	if (!strcmp (wstype, "graphon"))
	    fprintf (pltout, "\0332");
	else
	if (!strcmp (wstype, "retrographics"))
	    fprintf (pltout, "\033\"0g");
	else
	if (!strcmp (wstype, "selanar"))
	{
	    fprintf (pltout, "\0332");
	    fflush (pltout);
	    fprintf (pltout, "\033[>1t");	/* turn on text video */
	    fflush (pltout);
	}
	else
	if (!strcmp (wstype, "dscan"))
	    fprintf (pltout, "\033$");
	break;
    case CLOSE_FLUSH:
	fflush (pltout);
	break;
    case CLOSE_ERROR:
    case CLOSE_NORMAL:
	if (!strcmp (wstype, "retrographics"))
	    message (MESG_DONE);
	else
	    message (MESG_HOME);
	break;
    case CLOSE_INTERRUPT:
	if (!strncmp (wstype, "tek401", 6))
	{
	    message (MESG_READY);
	    message (MESG_TEXT, "\n\n\n");
	    message (MESG_DONE);
	    message (MESG_HOME);
	}
	else
	    if ((!strcmp (wstype, "graphon")) ||
		(!strcmp (wstype, "selanar")) ||
		(!strcmp (wstype, "dscan")))
	{
	    fprintf (pltout, "\n\n\n");
	    message (MESG_HOME);
	}
	else
	if (!strcmp (wstype, "retrographics"))
	    message (MESG_DONE);
	break;
    case CLOSE_PAUSE:
    case CLOSE_NOTHING:	/* No input */
    default:			/* not meant for us, ignore */
	break;
    }
}
