/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/teklib/setmode.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

/*
 * set and record new Tek mode
 *
 * N.B. we always issue a change to VECTOR when asked since this
 *		is how a move is implemented when we are in VECTOR mode
 *		already
 */
#include	<stdio.h>
#include	"tek.h"
extern FILE    *pltout;

int             tekmode = ALPHA;

setmode (mode)
    int             mode;
{
    switch (mode)
    {
    case VECTOR:
	putc (GS, pltout);
	tekmode = VECTOR;
	break;
    case ALPHA:
	if (tekmode != ALPHA)
	{
	    lost = 1;
	    putc (US, pltout);
	    tekmode = ALPHA;
	}
	break;
    case POINT:
	if (tekmode != POINT)
	{
	    lost = 1;
	    putc (FS, pltout);
	    tekmode = POINT;
	}
	break;
    }
}
