/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/cteklib/cteksetmode.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

/*
 * Three possible modes for the Tek 4105: ANSI, Tek (or alpha), and
 * vector input mode. This is the exclusive routine that keeps
 * track of which mode we are in, and does what is necessary to
 * change modes.
 */
/*
 * Updated to realize the fact that popping out to TEK mode loses
 * the train of vectors! (i.e. sets variable "lost" appropriately)
 */
#include	<stdio.h>
#include	"ctek.h"
extern FILE    *pltout;

int             lost;

cteksetmode (mode)
    int             mode;
{
static int      old_mode = ANSI;

    switch (mode)
    {
    case ANSI:
	if (old_mode == VECTOR)
	{
	    lost = 1;
	    Putc (US);
	    old_mode = TEK;
	}
	if (old_mode == TEK)
	{
	    fprintf (pltout, "%c%%!1", ESC);
	    old_mode = ANSI;
	}
	break;
    case TEK:
	if (old_mode == VECTOR)
	{
	    lost = 1;
	    Putc (US);
	    old_mode = TEK;
	}
	else
	if (old_mode == ANSI)
	{
	    fprintf (pltout, "%c%%!0", ESC);
	    old_mode = TEK;
	}
	break;
    case VECTOR:
	if (old_mode == TEK)
	{
	    Putc (GS);
	    old_mode = VECTOR;
	}
	else
	if (old_mode == ANSI)
	{
	    fprintf (pltout, "%c%%!0%c", ESC, GS);
	    old_mode = VECTOR;
	}
	break;
    }
}
