/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/cteklib/ctekmessage.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

/*
 * Device dependent subroutine to handle message operations
 */
#include	<stdio.h>
#include	"ctek.h"
#include	"../include/mesgcom.h"
#include	"../include/enum.h"
extern FILE    *pltout;

ctekmessage (command, string)
    int             command;
    char            string[];
{

    switch (command)
    {
    case MESG_HOME:		/* Home */
	cteksetmode (ANSI);
	fprintf (pltout, "%c[H", ESC);
	break;
    case MESG_READY:
	cteksetmode (ANSI);
	break;
    case MESG_TEXT:
	fprintf (pltout, "%s", string);
	break;
    case MESG_ON:		/* Turn on Text */
	cteksetmode (TEK);
	fprintf (pltout, "%cLV1", ESC);
	fflush (pltout);
	break;
    case MESG_OFF:		/* Turn off text */
	cteksetmode (TEK);
	fprintf (pltout, "%cLV0", ESC);
	fflush (pltout);
	break;
    case MESG_ERASE:		/* Erase Text */
	cteksetmode (TEK);
	fprintf (pltout, "%cLZ", ESC);
	fflush (pltout);
	break;
    case MESG_HIGHLIGHT_ON:
	fprintf (pltout, "%c[7m", ESC);
	break;
    case MESG_HIGHLIGHT_OFF:
	fprintf (pltout, "%c[0m", ESC);
	break;
    case MESG_DONE:
    default:
	fflush (pltout);
	break;
    }
}
