/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/cteklib/ctekgetpoint.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#include <stdio.h>
#include "ctek.h"

extern FILE    *pltout;
extern int      allowecho;

ctekgetpoint (termout, x, y)
    FILE           *termout;
    int            *x, *y;
{
char            string[80];

    fflush (pltout);
    cteksetmode (VECTOR);
    system ("stty echo");
    fprintf (pltout, "%c%c", ESC, SB);	/* Ask for position of cursor */
    fflush (pltout);
    fflush (termout);
    fread (string, 1, 6, termout);	/* Get answer */
    fflush (termout);
    if (string[0] == ESC)
	return (1);

    *x = (((string[1] & 037) << 5) | (string[2] & 037));
    *y = (((string[3] & 037) << 5) | (string[4] & 037));
    *x = *x * 4;
    *y = *y * 4;

    if (!allowecho)
	system ("stty -echo");

    lost = 1;
    return (0);
}
