/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/cteklib/ctekconf.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

/*
 * Tek 4100 series configuration
 * Keywords: pen vplot tek
 */
#include <stdio.h>
#include "../include/enum.h"
#include "../include/extern.h"

/*
 * mandatory declarations and initializations
 */
#ifdef SEP
char            name[] = "Ctekpen";
#else
char            name[] = "ctekpen";
#endif
#include "ctekdoc.h"

/*
 * device routine table
 */
extern int
ctekopen (), ctekreset (), ctekmessage (), ctekerase (), ctekclose ();
extern int
ctekattributes (), ctekstartpoly (), ctekmidpoly (), ctekendpoly ();
extern int
genvector (), gentext (), ctekraster ();
extern int
ctekplot (), ctekgetpoint ();
extern int
genpatarea (), genpoint (), genmarker ();
extern int
nulldev (), geninteract ();

struct device   dev = {

 /* control routines */
		       ctekopen,	/* open */
		       ctekreset,	/* reset */
		       ctekmessage,	/* message */
		       ctekerase,	/* erase */
		       ctekclose,	/* close */

 /* high level output */
		       genvector,	/* vector */
		       genmarker,	/* marker */
		       gentext,	/* text */
		       genpatarea,	/* area */
		       ctekraster,	/* raster */
		       genpoint,	/* point */
		       ctekattributes,	/* attributes */

 /* input */
		       ctekgetpoint,	/* getpoint */
		       geninteract,	/* interact */

 /* low level output */
		       ctekplot,	/* plot */
		       ctekstartpoly,	/* startpoly */
		       ctekmidpoly,	/* midpoly */
		       ctekendpoly,	/* endpoly */
};
