/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/gigilib/gigiplot.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#include <stdio.h>
#include "gigi.h"
extern FILE    *pltout;
extern int      dev_xmax, dev_ymax, dev_xmin, dev_ymin;
int             lost = 1;	/* used by genvector */

gigiplot (xnew, ynew, draw)
    int             xnew, ynew, draw;
{
int             ix, iy, dx, dy, gdx, gdy, adx, ady;
float           slope, x, y, fdx, fdy;
static int      xold, yold;

    gcon (&xnew, &ynew);	/* Convert to Gigi's perverse coordinate
				 * system */

    if (!in_a_poly)
    {
	if (!draw)
	{
	    if (lastop != 'P')
		fprintf (pltout, "P@W");
	}
	else
	{
	    if (lastop != 'V')
		fprintf (pltout, "V@W");
	}
    }

    if (lost == 0)
    {
	gdx = xnew - xold;
	gdy = ynew - yold;
	adx = (gdx > 0 ? gdx : -gdx);
	ady = (gdy > 0 ? gdy : -gdy);
	if (adx == 0 && ady == 0)
	    goto done;
    }
    else
    {
	lost = 0;
	adx = 100;
	ady = 100;
    }
    /* general move, fast for long vectors */
    if (adx > 10 || ady > 10)
    {
	fprintf (pltout, "[%d,%d]", 2 * ynew, 2 * xnew);
	goto done;
    }
    /* equivalent move, fast for short vectors */
    fdx = gdx;
    fdy = gdy;
    if (adx >= ady)
    {
	slope = 1.0001 * fdy / fdx;
	slope = (gdx > 0. ? slope : -slope);
	iy = yold;
	y = yold;
	for (ix = 0; ix < adx; ix++)
	{
	    y = y + slope;
	    dy = y - iy;
	    iy = iy + dy;
	    if (dy == 0)
	    {
		if (gdx > 0)
		    fprintf (pltout, "6");
		else
		    fprintf (pltout, "2");
	    }
	    else
	    if (dy > 0)
	    {
		if (gdx > 0)
		    fprintf (pltout, "7");
		else
		    fprintf (pltout, "1");
	    }
	    else
	    {
		if (gdx > 0)
		    fprintf (pltout, "5");
		else
		    fprintf (pltout, "3");
	    }
	}
    }
    else
    {
	slope = 1.0001 * fdx / fdy;
	slope = (gdy > 0. ? slope : -slope);
	ix = xold;
	x = xold;
	for (iy = 0; iy < ady; iy++)
	{
	    x = x + slope;
	    dx = x - ix;
	    ix = ix + dx;
	    if (dx == 0)
	    {
		if (gdy > 0)
		    fprintf (pltout, "0");
		else
		    fprintf (pltout, "4");
	    }
	    else
	    if (dx > 0)
	    {
		if (gdy > 0)
		    fprintf (pltout, "7");
		else
		    fprintf (pltout, "5");
	    }
	    else
	    {
		if (gdy > 0)
		    fprintf (pltout, "1");
		else
		    fprintf (pltout, "3");
	    }
	}
    }
done:
    if (!in_a_poly)
    {
	if (!draw)
	{
	    fprintf (pltout, "0V@W4");
	}
	lastop = 'V';
    }
    xold = xnew;
    yold = ynew;
    return;
}

gcon (x, y)
    int            *x, *y;
{
int             temp;

    temp = *x;
    *x = dev_ymin + dev_ymax - *y;
    *y = temp;
}
