/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/lprlib/lprvector.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#include <stdio.h>
#include "lprpen.h"
#include "../include/err.h"
#include "../include/enum.h"
#include "../include/extern.h"

/*
 * Vector rasterizes the line defined by the endpoints (x1,y1) and (x2,y2).
 */

extern int      lpr_color;

lprvector (x1, y1, x2, y2, nfat, dashon)
    int             x1, y1, x2, y2, nfat, dashon;
{
register int    test, bit, dx2, dy2, len;
register short *psec;
int             dx, dy, i;

    if (nfat < 0)
	return;

    if (dashon)
    {
	dashvec (x1, y1, x2, y2, nfat, dashon);
	return;
    }

    if (nfat)
    {
	fatvec (x1, y1, x2, y2, nfat, dashon);
	return;
    }

    if (clip (&x1, &y1, &x2, &y2))
	return;

    if (x2 >= xlimit)
    {
	/*
	 * Try expanding memory. If it fails take what we can get and
	 * rewindow the vector. Expand will print a warning message. 
	 */
	if (expand (x2) <= x2)
	    if (clip (&x1, &y1, &x2, &y2))
		return;
    }
    dx = (x2 > x1 ? x2 - x1 : x1 - x2);
    dy = (y2 > y1 ? y2 - y1 : y1 - y2);
    dx2 = dx << 1;
    dy2 = dy << 1;
    if (((dx < dy) && (y1 > y2)) || ((dx >= dy) && (x1 > x2)))
    {
	test = x1;
	x1 = x2;
	x2 = test;		/* swap endpoints to make */
	test = y1;
	y1 = y2;
	y2 = test;		/* intervals positive  */
    }
    psec = mem + x1 * NYW + (y1 >> 4);
    bit = 0100000 >> (y1 & 017);
    if (lpr_color > 0)
	*psec |= bit;		/* plot first point */
    else
	*psec &= ~bit;		/* plot first point */

    if (dx >= dy)		/* plot y = f(x)  */
    {
	len = dx;
	test = len - dy2;
	if (y2 > y1)
	{
	    while (len--)
	    {
		psec += NYW;
		if (test <= 0)	/* test for y increment */
		{
		    if ((bit = (bit >> 1)) == 0)
		    {
			bit = 0100000;
			psec++;
		    }
		    test += dx2;
		}
		if (lpr_color > 0)
		    *psec |= bit;
		else
		    *psec &= ~bit;
		test -= dy2;
	    }
	}
	else
	{
	    while (len--)
	    {
		psec += NYW;
		if (test <= 0)	/* test for y increment */
		{
		    if ((bit = (bit << 1)) == 0200000)
		    {
			bit = 01;
			psec--;
		    }
		    test += dx2;
		}
		if (lpr_color > 0)
		    *psec |= bit;
		else
		    *psec &= ~bit;
		test -= dy2;
	    }
	}
    }
    else			/* plot x = f(y)  */
    {
	len = dy;
	test = len - dx2;
	if (x2 > x1)
	{
	    while (len--)
	    {
		if (test <= 0)	/* test for x increment */
		{
		    psec += NYW;
		    test += dy2;
		}
		if ((bit = (bit >> 1)) == 0)
		{
		    bit = 0100000;
		    psec++;
		}
		if (lpr_color > 0)
		    *psec |= bit;
		else
		    *psec &= ~bit;
		test -= dx2;
	    }
	}
	else
	{
	    while (len--)
	    {
		if (test <= 0)	/* test for x increment */
		{
		    psec -= NYW;
		    test += dy2;
		}
		if ((bit = (bit >> 1)) == 0)
		{
		    bit = 0100000;
		    psec++;
		}
		if (lpr_color > 0)
		    *psec |= bit;
		else
		    *psec &= ~bit;
		test -= dx2;
	    }
	}
    }
}

/*
 * expand memory in units of 2*NYW*XINCSZ bytes.
 * If we fail to get more memory then use what
 * already have and set the window.
 */
expand (x)
    int             x;
{
int             xinc, desired, newxlimit, newsize;
short          *memhold;
char           *realloc ();

    xinc = ((x + XINCSZ) / XINCSZ) * XINCSZ - xlimit;
    desired = xinc;
    while (xinc > 0)
    {
	newsize = 2 * (xlimit + xinc) * NYW;
	memhold = mem;
	mem = (short *) realloc (memhold, newsize);
	if (mem != NULL)
	    break;
	mem = memhold;
	xinc -= XINCSZ;
    }
    newxlimit = xlimit + xinc;
    if (xinc < desired)
    {
	ERR (WARN, name,
	     "cannot expand memory. Plot limited to %6.2f inches",
	     (float) (newxlimit / 200.0));
	/* stop requests for more memory */
	xwmax = newxlimit - 1;
    }
    zap (&mem[xlimit * NYW], xinc);
    xlimit = newxlimit;
    return (xlimit);
}
