/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/gpslib/gpsopen.c
 *
 * Stew Levin (SEP), July 3 1987
 *	Copied from raslib and modified for gps (Masscomp color, I hope)
 */

#include <stdio.h>
#include "../include/enum.h"
#include "../include/extern.h"
#include "../include/err.h"
#include "../include/vplot.h"
#include <strings.h>
#ifdef SEP
#include <ctype.h>
#endif
#define DEFAULT_OUT	isatty(fileno(pltout))
#include "gpspen.h"

char           *image;
extern float    aspect_ratio;
extern float    pixels_per_inch;
int             color_mult;

extern int      num_col;

gpsopen ()
{
extern char   **xargv;
extern FILE    *pltout;
#ifdef SEP
extern int      headfd;
char            headname[30], fname[80];
char            path[50];
char           *front, *tail, *ptr;
#endif
char            newpath[60];
char            plpipe[60];

/*
 * physical device parameters
 */

/*
 * device capabilities
 */
    need_end_erase = YES;
    buffer_output = YES;
    smart_clip = NO;

    color_mult = 1;
    getpar ("colormult", "d", &color_mult);
    num_col = NCOLOR / color_mult;

    dev_xmin = -6554;		/* from default window 13 */
    dev_ymin = -6554;
    dev_xmax = 6553;
    dev_ymax = 6553;
    aspect_ratio = 1.;
    pixels_per_inch = RPERIN;	/* good enough */
    getpar ("aspect", "f", &aspect_ratio);
    getpar ("ppi", "d", &pixels_per_inch);
    allowecho = YES;

    if (DEFAULT_OUT)
    {
#ifdef SEP
	datapath (path);
/* Code stolen from output.c to get a reasonable raster file name. */
	if (0 < findnm (headfd, headname, sizeof (headname)))
	{
	    /* modify slightly */
	    strcpy (fname, "");
	    front = rindex (headname, '/');
	    if (front == ((char *) NULL))
		front = headname;
	    else
		front++;
	    if ((*front) == 'H')
		strcat (fname, ++front);
	    else
	    {
		tail = rindex (front, '.');
		if (tail == ((char *) NULL))
		    strcat (fname, front);
		else
		{
		    for (ptr = tail + 1; *ptr; ptr++)
			if (!isupper (*ptr))
			    break;
		    if (!(*ptr))/* drop suffix if all caps */
			*tail = '\0';
		    (void) strcat (fname, front);
		}
	    }
	    (void) strcat (fname, ".p");
	}
	else
	{
	    strcpy (fname, "gps.p");
	}

	sprintf (newpath, "%s%s", path, fname);
	Puthead ("\tin=%s\n", newpath);
#else
	sprintf (newpath, "%s", "gps.p");
#endif
	plpipe[0] = '\0';
    }
    else
    {
	newpath[0] = '\0';
	strcpy (plpipe, "cat");
    }
    new_plot (newpath, plpipe);
}
