/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/gpslib/gpsconf.c
 *
 * Stewart A. Levin (SEP), July, 3 1987
 *	Cribbed rasconf.c for gps filter
 */

/*
 * Keyword: vplot versatec color pen masscomp
 */
#include <stdio.h>
#include "../include/enum.h"
#include "../include/extern.h"
#include "gpspen.h"

/*
 * mandatory declarations and initializations
 */
#ifdef SEP
char            name[] = "Gpspen";
#else
char            name[] = "gpspen";
#endif
#include "gpsdoc.h"

/*
 * device routine table
 */
extern int
genmessage (), gpsopen (), genmarker ();
extern int
genvector (), gentext ();
extern int
genpoint (), gpsplot ();
extern int
vecarea (), genraster ();
extern int
nulldev (), gpsattr (), gpsreset (), gpsclose ();

struct device   dev =
{

 /* control routines */
 gpsopen,		/* open */
 gpsreset,		/* reset */
 genmessage,		/* message */
 nulldev,		/* erase */
 gpsclose,		/* close */

 /* high level output */
 genvector,		/* vector */
 genmarker,		/* marker */
 gentext,		/* text */
 vecarea,		/* area */
 genraster,		/* raster */
 genpoint,		/* point */
 gpsattr,		/* attributes */

 /* input */
 nulldev,		/* getpoint */
 nulldev,		/* interact */

 /* low level output */
 gpsplot,		/* plot */
 nulldev,		/* startpoly */
 nulldev,		/* midpoly */
 nulldev		/* endpoly */
};
