/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/gpslib/gpsattr.c
 *
 * Stewart A. Levin (SEP), July 3 1987
 *	Cribbed rasattr.c for gps filter
 */

/*
 * control graphics attributes
 */
#include <stdio.h>
#include "../include/attrcom.h"
#include "gpspen.h"
extern int      color_mult;
static int      regismap[8] = {0, 24, 26, 22, 25, 21, 23, 20};

gpsattr (command, value, v1, v2, v3)
    register int    command, value;
    int             v1, v2, v3;
{
int             bundle;
    switch (command)
    {
    case SET_COLOR:
	if (value < 8)
	    bundle = regismap[value];
	else
	    bundle = color_mult * value;
	line_style (bundle);
	/* text_style(bundle); /* unused; we don't do native text */
	break;
    case SET_COLOR_TABLE:
	/* Creare's crpf uses a fancy external table ... we'll do this later */
	break;
    case SET_WINDOW:
	/* use dumb clipping, I don't think gps windows and viewports */
	/* are of use for vplot's windowing                           */
    default:
	break;
    }

return 0;
}
