/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/imaglib/imagvector.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#define MAX_PEN 12
#include <stdio.h>
#include "../include/extern.h"
#include "imagen.h"
int             current_fat = 1;


imagvector (x1, y1, x2, y2, nfat, dashon)
    int             x1, y1, x2, y2;
    int             nfat, dashon;
{
static int      xlst, ylst;

    if (nfat < 0)
	return;

    if (dashon)
    {
	dashvec (x1, y1, x2, y2, nfat, dashon);
	return;
    }

    if (nfat + 1 > MAX_PEN)	/* Fatter than imagen can handle itself */
    {
	fatvec (x1, y1, x2, y2, nfat, dashon);
	return;
    }

    if (clip (&x1, &y1, &x2, &y2))
	return;

    if (current_fat != (nfat + 1))
    {
	endpath (DRAW_PATH, imag_curcolor);
	current_fat = (nfat + 1);
	fprintf (pltout, "%c%c", SET_PEN, lob (current_fat));
    }

    if ((x1 != xlst) || (y1 != ylst) || lost == 1)
    {
	/* Make sure it is a move, not a draw */
	imagplot (x1, y1, 0);
    }
    imagplot (x2, y2, 1);
    xlst = x2;
    ylst = y2;
}
