/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/imaglib/imagreset.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 * Stewart A. Levin (SEP), July 2, 1987
 *	Support command line ncopies= option
 */

#include <stdio.h>
#include "../include/enum.h"
#include "../include/extern.h"
#include "imagen.h"

imagreset ()
{
    /*
     * Make sure that the imagen knows this is in impress language! 
     */
    if (stripped == NO)
    {
	prepend (pltout);	/* puts in ipr's document control strings */
	fprintf (pltout, "@document(language ImPRESS, ");
	if (brute_force)
	    fprintf (pltout, "prerasterization on, ");
	if (holdreason[0] != '\0')
	    fprintf (pltout, "hold \"%s; 'rj' to proceed\", ",
		     holdreason);
	fprintf (pltout, "copies %d, ", ncopies_document);
	fprintf (pltout, "jobheader off)");
    }
    if (label[0] != '\0')
    {
	fprintf (pltout, "%c%c%c%c%s%c", CREATE_FAMILY_TABLE,
		 '\002', '\001', '\000', "COUR12", '\0');
    }
    if (tex == YES)
    {
	fprintf (pltout, "%c%c%c", SET_PUSH_MASK, '\001', '\377');
	fprintf (pltout, "%c", PUSH);
	fprintf (pltout, "%c%c", SET_HV_SYSTEM, '\143');
    }
}


#include <pwd.h>
static
prepend (newfile)
    FILE           *newfile;
{
    /*
     * Stolen from ipr to set up document control 
     */

char            SYSIDENT[256];
register char  *sp, *dp;
long            spooltime;
struct passwd  *pw, *getpwuid ();
long            time ();/* Date/time-getting support */
char           *ctime ();
char            now[32];

    /* Add a document header to this file */
    time (&spooltime);
    sp = ctime (&spooltime);
    dp = now;
    while (*sp && *sp != '\n')
	*dp++ = *sp++;
    *dp = '\0';
    fprintf (newfile, "@document(");
    pw = getpwuid (getuid ());
    gethostname (SYSIDENT, sizeof (SYSIDENT));
    if (pw != 0)
    {
	fprintf (newfile, "owner \"%s", pw->pw_name);
	if (pw->pw_gecos != 0 && pw->pw_gecos[0] != '\0')
	    fprintf (newfile, " (%s)", pw->pw_gecos);
	fprintf (newfile, "\", site \"%s\"", SYSIDENT);
    }
    else
	fprintf (newfile, "site \"%s\"", SYSIDENT);
    fprintf (newfile, ", spooldate \"%s\"", now);
    fprintf (newfile, ")");

}
