/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/imaglib/imagpoly.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#include <stdio.h>
#include "imagen.h"
#include "../include/extern.h"
#include "../include/err.h"
#include "../include/params.h"
#include "../include/pat.h"
extern FILE    *pltout;

extern int      ipat;
extern struct pat pat[];

static int      loaded[NPAT];
static int      lastcolor = BLACK, lastxmask = 0, lastymask = 0, lasttexture = 0;
static int      loadm[96][3], ldnum = 1;

static int      draw;

imagstartpoly (npts)
    int             npts;
{
unsigned int    imask[32];
int             ix, iy, nx, ny, xmax, ymax, i, n, xmask, ymask;
int            *bptr;
char            cbuf[80];

    draw = 0;
    endpath (DRAW_PATH, imag_curcolor);	/* sets lost=1 for us as well */
/*
 * Don't go more than a PATHLENGTH worth or addpath will draw it as a path!
 * This is no limitation, because the imagen can't hold paths any longer
 * than that anyway. So it is up to the user to fragment his polygon.
 */
    if (npts > PATHLENGTH - 2)
	ERR (FATAL, name, "Too many points in this polygon for the imagen!");

/* pattern filling stuff */
    if (ipat == 0)
    {				/* masking -- old area command */
	xmask = pat[0].xdim;
	ymask = pat[0].ydim;
	if (lasttexture >= 0 || lastxmask != xmask || lastymask != ymask || lastcolor != imag_curcolor)
	{
	    for (n = 1; n < ldnum; n++)
	    {			/* check to see if the pattern is already
				 * downloaded */
		if (loadm[n][0] == xmask && loadm[n][1] == ymask
		    && loadm[n][2] == imag_curcolor)
		    break;
	    }
	    if (n == ldnum && n < 96)
	    {			/* not loaded yet */
		for (i = 0; i < 32; i++)
		    imask[i] = 0;
		if (xmask && ymask && imag_curcolor == BLACK)
		{
		    for (iy = 0; iy < 32; iy += ymask)
			imask[0] |= (01 << iy);
		    for (ix = xmask; ix < 32; ix += xmask)
			imask[ix] = imask[0];
		}
		loadglyph (11, n, imask);
		loadm[n][0] = xmask;
		loadm[n][1] = ymask;
		loadm[n][2] = imag_curcolor;
		ldnum++;
	    }
	    settexture (11, n);
	    lasttexture = -n;
	    lastxmask = xmask;
	    lastymask = ymask;
	    lastcolor = imag_curcolor;
	}
    }
    else
    {				/* loaded patterns */
	if (pat[ipat].patbits == NULL)
	{
	    sprintf (cbuf, "Pattern number %d not loaded.", ipat);
	    ERR (WARN, name, cbuf);
	    settexture (0, 0);
	    lasttexture = 0;
	    return;
	}
	if (ipat < 0)
	{
	    settexture (0, 0);
	    lasttexture = 0;
	    return;
	}
	if (lasttexture != ipat)
	{
	    if (!loaded[ipat])
	    {
		nx = pat[ipat].xdim;
		ny = pat[ipat].ydim;
		bptr = pat[ipat].patbits;
		if (nx > 32 || ny > 32)
		{
		    ERR (WARN, name, "Imagen pattern fill is 32 bits by 32 bits;\n\tGot %d by %d, so truncating.", nx, ny);
		}
		if ((nx < 32 && nx != 16 && nx != 8 && nx != 4 && nx != 2 && nx != 1) ||
		    (ny < 32 && ny != 16 && ny != 8 && ny != 4 && ny != 2 && ny != 1))
		{
		    ERR (WARN, name, "Imagen pattern fill is 32 bits by 32 bits;\n\tGot %d by %d, so partially replicating.", nx, ny);
		}
		xmax = (nx < 32) ? nx : 32;
		ymax = (ny < 32) ? ny : 32;
		for (i = 0; i < 32; i++)
		    imask[i] = 0;
/*
 * IMPRESS bit order for pattern filling starts at lower left and scans upward
 * along the left edge, then left to right by columns.  This would be standard
 * order for a page oriented for text, but not for our graphics convention
 * of x-direction is paper-feed direction.
 */

		for (iy = 0; iy < ymax; iy++)
		{
		    for (ix = 0; ix < xmax; ix++)
		    {
			if (*bptr++)
			{
			    imask[ix] |= (01 << iy);
			}
		    }
		    if (nx > 32)
		    {
			for (; ix < nx; ix++)
			    bptr++;	/* discard extra y-bits */
		    }
		}
		if (ny < 32)
		{		/* replicate in y-direction */
		    do
		    {
			for (ix = 0; ix < xmax; ix++)
			    imask[ix] |= (imask[ix] << iy);
			iy *= 2;
		    } while (iy < 32);
		}
		for (ix = xmax; ix < 32; ix++)
		{		/* replicate in x-direction */
		    imask[ix] = imask[ix - nx];
		}
		loadglyph (10, ipat, imask);
		loaded[ipat] = 1;
	    }
	    settexture (10, ipat);
	    lasttexture = ipat;
	}
    }
}


imagmidpoly (x, y)
    int             x, y;
{
    imagplot (x, y, draw);
    draw = 1;
}

imagendpoly (done)
    int             done;
{
extern int      overlay;
int             overlay_im;

    switch (overlay)
    {
    case 0:
	overlay_im = OPAQUE;
	break;
    case 1:
	overlay_im = OR;
	break;
    }
    endpath (FILL_PATH, overlay_im);
}

settexture (family, member)
{
    putc (SET_TEXTURE, pltout);
    putrfm (0, family, member);
}

loadglyph (family, member, imask)
    unsigned int    imask[];
{
int             i;

    putc (BGLY, pltout);
    putrfm (0, family, member);
    put2byte (0);
    put2byte (32);
    put2byte (0);
    put2byte (32);
    put2byte (0);
    for (i = 0; i < 32; i++)
    {
	put4byte (imask[i]);
    }
}

putrfm (rot, fam, mem)
{
char            rfm1, rfm2;

    rfm1 = ((rot & 03) << 6) | ((unsigned) (fam & 0177) >> 1);
    rfm2 = ((fam & 01) << 7) | (mem & 0177);
    putc (rfm1, pltout);
    putc (rfm2, pltout);
}

put2byte (in)
    unsigned int    in;
{
char            c;

    c = (in >> 8) & 0xff;
    putc (c, pltout);
    c = (in & 0xff);
    putc (c, pltout);
}

put4byte (in)
    unsigned int    in;
{
char            c;

    c = (in >> 24) & 0xff;
    putc (c, pltout);
    c = (in >> 16) & 0xff;
    putc (c, pltout);
    c = (in >> 8) & 0xff;
    putc (c, pltout);
    c = (in & 0xff);
    putc (c, pltout);
}
