/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/imaglib/imagopen.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 * Stew Levin (SEP), July 2, 1987
 *	Added ncopies= command line option.
 */

/*
 * get Imagen specific parameters and go
 */
#include <stdio.h>
#include "../include/err.h"
#include "../include/enum.h"
#include "../include/extern.h"
#include "../include/params.h"

#define BRUTE_DEFAULT YES

#ifdef SEP
#define GETPAR fetch
#else
#define GETPAR getpar
#endif

int             file_created = NO;
int             stripped = NO;
int             tex = NO;
int             brute_force = BRUTE_DEFAULT;
int             ncopies_document = 1;
char            label[100];
char            string[80];

char            mapfile[100] = "default";
char            holdreason[100];
char            scratch_file[100];

/*
 * The option "strip=y" was created for use with TEX, allowing plots
 * to be included with text. The output is not indented, does not have
 * any job control information at the start, has no erases, no "end of
 * form" marker at the end, and does not attempt to put in a label.
 * The option "tex=y" does everything that strip does but also rotates
 * the coordinates (as appropriate for dviimp), and saves and restores
 * all settings. "hold=reason" to insert document control to tell the
 * imagen not to print the job until a "release jobs" (rj) is issued
 * at the imagen control console.  This makes it easier to insert
 * special paper for example.
 */

imagopen ()
{
char            name[50];
char            date[50];

/*
 * physical device parameters
 */
    dev_xmin = 45;
    dev_ymin = 90;
    pixels_per_inch = 300.;
    aspect_ratio = 1.0;

/*
 * device capabilities
 */
    need_end_erase = YES;
    buffer_output = YES;
    smart_clip = NO;
    num_col = 0;
    mono = 1;
    dither = 3;
    pixc = 0.6;
    greyc = -0.5;

/* Since this is a hard copy device, might as well use a nice font */
    txfont = DEFAULT_HARDCOPY_FONT;
    txprec = DEFAULT_HARDCOPY_PREC;

    if (!GETPAR ("label", "s", label))
    {
	getname (name);
	getdate (date);
	sprintf (label, "%s, %s", name, date);
    }
    else
    {
	if ((strcmp (label, "no") == 0) || (strcmp (label, "n") == 0)
	    || (strcmp (label, " ") == 0) || (strcmp (label, "") == 0))
	    label[0] = '\0';
    }

    if (isatty (fileno (pltout)))
    {
	file_created = YES;
	sprintf (scratch_file, "%s%s", IPEN_SPOOL, "/Impress_XXXXXX");
	mktemp (scratch_file);
	pltout = fopen (scratch_file, "w");
	if (pltout == NULL)
	{
	    ERR (FATAL, name, "could not open scratch file %s!",
		 scratch_file);
	}
    }

    if (GETPAR ("paper", "s", string))
    {
	if (strcmp (string, "legal") == 0)
	{
	    dev_xmax = 4032 - 20;
	    dev_ymax = 2416 - 1;
	}
	else
	if (strcmp (string, "letter") == 0)
	{
	    dev_xmax = 3296 - 20;
	    dev_ymax = 2416 - 1;
	}
	else
	{
	    ERR (FATAL, name, "don't recognize paper type %s!", string);
	}
    }
    else
    {
	/* letter */
	dev_xmax = 3296 - 20;
	dev_ymax = 2416 - 1;
    }

    if (GETPAR ("tex", "s", string))
    {
	if ((string[0] == 'y') || (string[0] == 'Y'))
	    stripped = YES;
    }
    else
    if (GETPAR ("strip", "s", string))
    {
	if ((string[0] == 'y') || (string[0] == 'Y'))
	    stripped = YES;
    }

    if (stripped == YES)
    {
	/* Don't leave space at edge of plot */
	dev_xmax -= dev_xmin;
	dev_xmin = 0;
/*
 * Make plotting surface big enough that no matter which way they
 * may use the plot, nothing will be clipped. The imagen is SUPPOSED
 * to be able to handle stuff going off the page anyway.
 */
	dev_ymax = dev_xmax;
	dev_ymin = dev_xmin;

	/* TEX shifts plot 1 inch to the right; undo this */
	dev_xmax -= 300;
	dev_xmin -= 300;

	/* Turn off label */
	label[0] = '\0';
    }
    else
    {
	if (GETPAR ("brute", "s", string))
	{
	    if ((string[0] == 'n') || (string[0] == 'N'))
		brute_force = NO;
	    else
		brute_force = YES;
	}
    }

    if (!GETPAR ("hold", "s", holdreason))
    {
	holdreason[0] = '\0';
    }

    if (!GETPAR ("ncopies copies", "i", &ncopies_document))
    {
	ncopies_document = 1;
    }

    epause = 0;
    endpause = NO;
    size = ABSOLUTE;
}


/*
 * get the login name of the person running the program.
 */
getname (name)
    char           *name;
{
char            line[100];
int             i;
    getpw (getuid (), line);
    i = 0;
    while ((name[i] = line[i]) != ':')
	i++;
    name[i] = '\0';
}

/*
 * get the date
 */
#include <sys/time.h>
getdate (date)
    char           *date;
{
long            time ();
long            clock;
struct tm      *localtime ();
char           *asctime ();

    clock = time (0);
    sprintf (date, "%.16s", asctime (localtime (&clock)));
}
