/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/envilib/enviset.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#include	<stdio.h>
#include	"../include/err.h"
#include	"../include/extern.h"
#include    "envi.h"

/*
 *  Please note that this routine is NEVER CALLED by screenpen or any of
 * the device independent routines! They don't even know what a mode is.
 * This routine is only called by device dependent routines in this library.
 * Making one routine responsible for keeping track of the terminal's mode
 * saves a lot of trouble. The envision is a simple case, with only 2 modes
 * it can be in.
 */

envisetmode (mode)	/* Get the terminal into the required mode */
    int             mode;
{
static int      current_mode = REG;
    switch (mode)
    {
    case MOV:
	if (current_mode == MOV)
	    return;
	else
	if (current_mode == TEK)
	    putc (US, pltout);
	putc (FS, pltout);
	current_mode = MOV;
	lost = 1;
	return;

    case TEK:
	if (current_mode == TEK)
	    return;
	else
	if (current_mode == MOV)
	    putc (US, pltout);
	putc (GS, pltout);
	current_mode = TEK;
	lost = 1;
	break;

    case REG:
	if (current_mode == REG)
	    return;
	/*
	 * Envision Documentation says you also need an ESC at this point,
	 * but tek's don't use it, and it seems to work. 
	 */
	putc (US, pltout);
	current_mode = REG;
	lost = 1;		/* vector is warned */
	break;

    default:
	ERR (FATAL, name, "setmode: I've never heard of that mode before!");
	break;
    }
}

envipanon ()
{
    if (version > 215)
	fprintf (pltout, "%cRP1", ESC);
}

envipanoff ()
{
    if (version > 215)
	fprintf (pltout, "%cRP0", ESC);
}

envisetpan ()
{
    envisoftkeyoff ();
    fprintf (pltout, "%cRG1", ESC);
    if (version > 215)
	fprintf (pltout, "%cRP1", ESC);
}

enviresetpan ()
{
    envisoftkeyon ();
    fprintf (pltout, "%cRG0", ESC);
    if (version > 215)
	fprintf (pltout, "%cRP0", ESC);
}

enviresetcolors ()
{
    fprintf (pltout, "%cQ ", ESC);
}

envinograph ()
{
    fprintf (pltout, "%cRR0", ESC);
}

envicursoron ()
{
    fprintf (pltout, "%cG1", ESC);
}

envicursoroff ()
{
    fprintf (pltout, "%cG0", ESC);
}

envisoftkeyon ()
{
    fprintf (pltout, "%c>", ESC);
}

envisoftkeyoff ()
{
    fprintf (pltout, "%c=", ESC);
}
