/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/envilib/envireset.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#include <stdio.h>
#include "../include/extern.h"
#include "envi.h"

envireset ()
{
extern FILE    *pltout;
extern int      dev_xmax, dev_ymax, dev_xmin, dev_ymin;

/*
 * physical device size
 */
    dev_xmax = 639;
    dev_xmin = 0;
    dev_ymin = 0;
    pixels_per_inch = 67.;
    aspect_ratio = 1.;
    num_col = 8;

    /*
     * Reset the terminal. On the Envision, it is a pain To do this without
     * logging the person out! (Escape C) 
     */
    putc (ESC, pltout);
    fprintf (pltout, "OR1");
    /* Select decimal mode. Slower, but I'm lazy */
    /*
     * Almost all actual drawing is done in tek mode, and that is in binary,
     * and optimized. So don't get too upset about this inefficiency. 
     */
    putc (ESC, pltout);
    fprintf (pltout, "G0");	/* Turn off Graphics Cursor */
    putc (ESC, pltout);
    fprintf (pltout, "T0");	/* Turn off dotted lines */
    putc (ESC, pltout);
    fprintf (pltout, "L0");	/* Select Drawing Logic mode 0 */
    putc (ESC, pltout);
    fprintf (pltout, "OW%d,%d,%d,%d,", dev_xmin * 4, dev_ymin * 4,
	     (dev_xmax + 1) * 4, (dev_ymax + 1) * 4);
    /*
     * This really sets the window to xmin =0, ymin=0, xmax= xmax, ymax=ymax
     * . (Note these were set by termfirst) This is chosen so that 1 pixel
     * equals 1 unit. For some reason, whenever we are in Tektronix emulation
     * mode, the window is 1/4'd ! So we have to multiply by 4 to start with!
     * Strange, huh? The "+1" was added to get around an apparent slight
     * envision bug. (Lost top row of pixels) 
     */
    putc (ESC, pltout);
    fprintf (pltout, "J7");	/* Enable all Color planes */
    putc (ESC, pltout);
    fprintf (pltout, "C7");	/* Set drawing color to white */
    putc (ESC, pltout);
    fprintf (pltout, "B0");	/* Set background color to black */

    /* Turn all the guns on all the way */
    fprintf (pltout, "%cQ0000%cQ1?00%cQ20?0%cQ3??0%cQ400?%cQ5?0?%cQ60??%cQ7???"
	     ,ESC, ESC, ESC, ESC, ESC, ESC, ESC, ESC);
    fprintf (pltout, "%cRR1", ESC);	/* Turn the graphics plane on */
    fprintf (pltout, "%cOH0", ESC);	/* Set polygon fill style */
    envisetpan ();		/* Set Graph and Pan mode, turn off soft keys */
}
