/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/envilib/envipoly.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#include <stdio.h>
#include "envi.h"

extern FILE    *pltout;

static int      firstpoint;
static int      x_first, y_first;

envistartpoly (npts)
    int             npts;
{
    envisetmode (REG);
    fprintf (pltout, "%cOM%d,", ESC, npts + 1);
    firstpoint = 1;
}


envimidpoly (x, y)
    int             x, y;
{
    fprintf (pltout, "%d,%d,", x * 4, y * 4);
    if (firstpoint == 1)
    {
	firstpoint = 0;
	x_first = x;
	y_first = y;
    }
    /*
     * Multiply by 4 to undo the window weirdness. That is, when in tek mode
     * the window acts differently from when not in tek mode. 
     */
}

enviendpoly (last)
    int             last;	/* 1 means this is the last polygon */
{
    fprintf (pltout, "%d,%d,", x_first * 4, y_first * 4);
/*
 * repeat the first point as the last to get around an envision bug!
 */
}
