/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/envilib/enviconf.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

/*
 * Envision configuration, models 215 and 220.
 * The only difference between these two is in the open routine.
 * Several configuration variables are reset.
 * Keyword: envision pen vplot
 */
#include <stdio.h>
#include "../include/extern.h"

/*
 * mandatory declarations
 */
#ifdef SEP
char            name[] = "Envipen";
#else
char            name[] = "envipen";
#endif
#include "envidoc.h"

/*
 * device routine table
 */
extern int
enviopen (), envireset (), envimessage (), envierase (), enviclose ();
extern int
genvector (), gentext (), genraster1 ();
extern int      enviattributes ();
extern int
enviplot (), envistartpoly (), envimidpoly (), enviendpoly ();
extern int
genarea (), envipoint (), genmarker ();
extern int
envigetpoint (), vecarea (), nulldev (), geninteract ();

struct device   dev =
{
 /* control routines */
 enviopen,		/* open */
 envireset,		/* reset */
 envimessage,		/* message */
 envierase,		/* erase */
 enviclose,		/* close */

 /* high level output */
 genvector,		/* vector */
 genmarker,		/* marker */
 gentext,		/* text */
 genarea,		/* area */
 genraster1,		/* raster */
 envipoint,		/* point */
 enviattributes,	/* attributes */

 /* input */
 envigetpoint,		/* getpoint */
 geninteract,		/* interact */

 /* low level output */
 enviplot,		/* plot */
 envistartpoly,		/* startpoly */
 envimidpoly,		/* midpoly */
 enviendpoly		/* endpoly */
};
