/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/envilib/enviclose.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#include <stdio.h>
#include "../include/mesgcom.h"
#include "../include/closestat.h"
#include "envi.h"


extern FILE    *pltout;

extern int      out_isatty;
int             want_bell = 1;

enviclose (status)
    int             status;
{
    switch (status)
    {
    case CLOSE_FLUSH:
	fflush (pltout);
	break;
    case CLOSE_PAUSE:
	envisetmode (REG);
	if (want_bell == 1)
	{
	    fprintf (pltout, "\007");
	}
	fflush (pltout);
	break;
    case CLOSE_NORMAL:
	break;
    case CLOSE_DONE:
	envisetmode (REG);
	if (out_isatty)
	{
	    enviresetcolors ();
	    envinograph ();
	}
	enviresetpan ();
	envicursoroff ();
	fflush (pltout);
	break;
    case CLOSE_ERROR:
	break;
    case CLOSE_INTERRUPT:
	envisetmode (REG);
	putc (US, pltout);
	putc (US, pltout);
	fprintf (pltout, "%c\n\n", ESC);
	putc (US, pltout);
	putc (US, pltout);
	putc (US, pltout);
	putc (US, pltout);
	putc (US, pltout);
	putc (US, pltout);
	fprintf (pltout, "%c\n", ESC);
	putc (US, pltout);
	enviresetcolors ();
	envinograph ();
	enviresetpan ();
	envicursoroff ();
	enviresetcolors ();
	envinograph ();
	enviresetpan ();
	fprintf (pltout, "%c\n", ESC);
	enviresetcolors ();
	envinograph ();
	enviresetpan ();
	envicursoroff ();
	fflush (pltout);
	break;
    case CLOSE_NOTHING:
	break;
    default:
	break;
    }
}
