/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/envilib/enviattr.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#include <stdio.h>
#include <math.h>
#include "../include/attrcom.h"
#include "../include/params.h"
#include "envi.h"

extern FILE    *pltout;

enviattributes (command, value, v1, v2, v3)
    register int    command, value;
    int             v1, v2, v3;
{
int             icol;

    switch (command)
    {
    case SET_COLOR:
	envisetmode (REG);
	if ((version < 220 && value < 8) || (version >= 220 && value < 16))
	{
	    if (value < 8)
	    {
		/* Convert from Regis colors to Envision Colors */
		icol = (int) (value / 2) + (value - 2 * (int) (value / 2)) * 4;
	    }
	    else
	    {
		icol = value;
	    }
	    fprintf (pltout, "%cC%c", ESC, icol + '0');
	}
	else
	{
	    /* Try some sort of a fill pattern instead */
	    /* Cycle through colors, skipping black */
	    icol = 1 + ((value - 8) % 7);
	    icol = (int) (icol / 2) + (icol - 2 * (int) (icol / 2)) * 4;
	    fprintf (pltout, "%cC%c", ESC, icol + '0');
	    /* Also cycle through patterns everytime colors flip */
	    icol = floor ((float) (value - 8) / 7.);
	    icol = icol % 33;
	    fprintf (pltout, "%cOH%c", ESC, icol + '0');
	}
	break;
    case SET_COLOR_TABLE:
	/* 220 can't reset colors 8-15 ... stupid terminal has another bug */
	if (value < 8)
	{
	    envisetmode (REG);
	    if (value < 8)
	    {
		/* Convert from Regis colors to Envision Colors */
		icol = (int) (value / 2) + (value - 2 * (int) (value / 2)) * 4;
	    }
	    else
	    {
		icol = value;
	    }
	    v1 /= (int) ((MAX_GUN + 1) / 16);
	    v2 /= (int) ((MAX_GUN + 1) / 16);
	    v3 /= (int) ((MAX_GUN + 1) / 16);
	    fprintf (pltout, "%cQ%c%c%c%c",
		     ESC, icol + '0', v1 + '0', v2 + '0', v3 + '0');
	}
	break;
    default:
	break;
    }

    return 0;
}
