#include <stdio.h>
#include <time.h>
#include "vort.h"

/*
 * pixinfo
 *
 *	provides some details as to what a pix file contains
 */
main(ac, av)
	int	ac;
	char	**av;
{
	image		*im;
	int		w, h;

	if ((im = openimage(av[1], "r")) == (image *)NULL) {
		fprintf(stderr, "pixinfo: can't open image file.\n");
		exit(1);
	}

	w = imagewidth(im);
	h = imageheight(im);

	switch (imagetype(im)) {
	case PIX_RGB:
		printf("rgb image %d by %d.\n", w, h);
		break;
	case PIX_RLE:
		printf("runlength encoded rgb image %d by %d.\n", w, h);
		break;
	case PIX_RGBA:
		printf("rgb-alpha image %d by %d.\n", w, h);
		break;
	case PIX_RLEA:
		printf("rgb-alpha runlength encoded image %d by %d.\n", w, h);
		break;
	case PIX_CMAP:
		printf("rgb colour-mapped image %d by %d.\n", w, h);
		break;
	case PIX_RLECMAP:
		printf("runlength encoded rgb colour-mapped image %d by %d.\n", w, h);
		break;
	default:
		fprintf(stderr, "pixinfo: not a pix image.\n");
		exit(1);
	}

	printf("creation date: %s", ctime(&imagedate(im)));

	if (imagetype(im) == PIX_CMAP)
		printf("colourmap size %d.\n", cmapsize(im));
	else if (imagetype(im) == PIX_RLECMAP) 
		printf("colourmap size %d.\n", cmapsize(im));

	if (*imagetitle(im) != 0)
		printf("imagetitle: %s\n", imagetitle(im));

	exit(0);
}
