#include <math.h>
#include <stdio.h>
#include "art.h"
#include "macro.h"
#include "gram.h"

extern hlist	*fhlist;

typedef struct cl {
	char		*name;
	object		*obj;
	struct cl	*nxt;
} csglist; 

csglist		*head;

/*
 * csgaddi
 *
 *	a list of points hit by r in the csg tree formed by a union
 * operation, NULL otherwise
 *
 */
hlist *
csgaddi(r, o, last)
	register ray	*r;
	register object	*o;
	hlist		**last;
{
	csg		*tree;
	hlist		tmp, *lend, *rend;
	register int	leftb, rightb;
	register hlist	*lls, *rls, *next, *p, *lp;

	tree = o->obj.csgt;
	lls = tree->left->intersects(r, tree->left, &lend);
	rls = tree->right->intersects(r, tree->right, &rend);
	
	if (lls == rls)
		return((hlist *)NULL);

	leftb = tree->leftb;
	rightb = tree->rightb;

	for (p = lls; p != (hlist *)NULL; p = p->nxt)
		leftb = !leftb;

	for (p = rls; p != (hlist *)NULL; p = p->nxt)
		rightb = !rightb;

	next = &tmp;
	while (lls != (hlist *)NULL && rls != (hlist *)NULL) {
		if (lls->t < rls->t) {
			if (rightb) {
				next->nxt = lls;
				next = next->nxt;
				lls = lls->nxt;
			} else {
				p = lls;
				lls = lls->nxt;
				release(p);
			}
			leftb = !leftb;
		} else {
			if (leftb) {
				next->nxt = rls;
				next = next->nxt;
				rls = rls->nxt;
			} else {
				p = rls;
				rls = rls->nxt;
				release(p);
			}
			rightb = !rightb;
		}
	}

	if (lls != (hlist *)NULL && rightb) {
		next->nxt = lls;
		*last = lend;
		for (lp = rls; lp != (hlist *)NULL; lp = p) {
			p = lp->nxt;
			release(lp);
		}
	} else if (rls != (hlist *)NULL && leftb) {
		next->nxt = rls;
		*last = rend;
		for (lp = lls; lp != (hlist *)NULL; lp = p) {
			p = lp->nxt;
			release(lp);
		}
	} else {
		next->nxt = (hlist *)NULL;
		*last = next;
		for (lp = rls; lp != (hlist *)NULL; lp = p) {
			p = lp->nxt;
			release(lp);
		}
		for (lp = lls; lp != (hlist *)NULL; lp = p) {
			p = lp->nxt;
			release(lp);
		}
	}

	return(tmp.nxt);
}

/*
 * csgsubinti
 *
 *	a list of points hit by r in the csg tree resulting form a subtract
 * or an intersection operation, NULL otherwise
 *
 */
hlist *
csgsubinti(r, o, last)
	register ray	*r;
	register object	*o;
	hlist		**last;
{
	csg		*tree;
	hlist		tmp, *lend, *rend;
	register int	leftb, rightb;
	register hlist	*lls, *rls, *next, *p, *lp;

	tree = o->obj.csgt;
	lls = tree->left->intersects(r, tree->left, &lend);

	if (lls == (hlist *)NULL)
		return((hlist *)NULL);

	rls = tree->right->intersects(r, tree->right, &rend);
	
	leftb = tree->leftb;
	rightb = tree->rightb;

	for (p = lls; p != (hlist *)NULL; p = p->nxt)
		leftb = !leftb;

	for (p = rls; p != (hlist *)NULL; p = p->nxt)
		rightb = !rightb;

	next = &tmp;
	while (lls != (hlist *)NULL && rls != (hlist *)NULL) {
		if (lls->t < rls->t) {
			if (rightb) {
				next->nxt = lls;
				next = next->nxt;
				lls = lls->nxt;
			} else {
				p = lls;
				lls = lls->nxt;
				release(p);
			}
			leftb = !leftb;
		} else {
			if (leftb) {
				next->nxt = rls;
				next = next->nxt;
				rls = rls->nxt;
			} else {
				p = rls;
				rls = rls->nxt;
				release(p);
			}
			rightb = !rightb;
		}
	}

	if (lls != (hlist *)NULL && rightb) {
		next->nxt = lls;
		*last = lend;
		for (lp = rls; lp != (hlist *)NULL; lp = p) {
			p = lp->nxt;
			release(lp);
		}
	} else if (rls != (hlist *)NULL && leftb) {
		next->nxt = rls;
		*last = rend;
		for (lp = lls; lp != (hlist *)NULL; lp = p) {
			p = lp->nxt;
			release(lp);
		}
	} else {
		next->nxt = (hlist *)NULL;
		*last = next;
		for (lp = rls; lp != (hlist *)NULL; lp = p) {
			p = lp->nxt;
			release(lp);
		}
		for (lp = lls; lp != (hlist *)NULL; lp = p) {
			p = lp->nxt;
			release(lp);
		}
	}

	return(tmp.nxt);
}

/*
 * csgn
 *
 *	would normally return the normal to the surface, but as we are 
 * dealing with a csg tree it is used for debugging only.
 */
/*ARGSUSED*/
void
csgn(n, l, o)
	register vector	*n, *l;
	register object	*o;
{
	fatal("art: bad function in csg normal.\n");
}

/*
 * savecsgobj
 *
 *	store a csg object in the csg table
 */
savecsgobj(name, o)
	char	*name;
	object	*o;
{
	csglist	*p;

	p = (csglist *)smalloc(sizeof(csglist));
	p->name = name;
	p->obj = o;

	p->nxt = head;
	head = p;
}

/*
 * getcsgobj
 *
 *	retrieve a csg object from the csg table
 */
object *
getcsgobj(name)
	char	*name;
{
	csglist	*p;

	for (p = head; p != (csglist *)NULL; p = p->nxt) {
		if (strcmp(name, p->name) == 0)
			return(p->obj);
	}

	return((object *)NULL);
}

/*
 * getcsgexp
 *
 *	set up the expression node for a csg tree
 */
object *
getcsgexp(op, left, right)
	int	op;
	object	*left, *right;
{
	register object	*o;
	register csg	*c;

	o = (object *)smalloc(sizeof(object));

	o->type = CSG;
	o->normal = csgn;

	setshader(o);

	c = o->obj.csgt = (csg *)smalloc(sizeof(csg));

	c->left = left;
	c->right = right;

	switch (c->op = op) {
	case SUBTRACT:
		o->intersects = csgsubinti;
		c->leftb = FALSE;
		c->rightb = TRUE;
		break;
	case UNION:
		o->intersects = csgaddi;
		c->leftb = TRUE;
		c->rightb = TRUE;
		break;
	case INTERSECT:
		o->intersects = csgsubinti;
		c->leftb = FALSE;
		c->rightb = FALSE;
		break;
	default:
		fatal("art: illegal op type in csg tree.\n");
	}
	
	return(o);
}
