#include <math.h>
#include <stdio.h>
#include "art.h"
#include "macro.h"
#include "gram.h"

extern attr	*astackp;
extern hlist	*fhlist;
extern hlist	*trace();

/*
 * compi
 *
 *	returns a list of intersection points for the ray r and composite
 * object o.
 */
hlist *
compi(r, o, last)
	register ray	*r;
	register object	*o;
	hlist		**last;
{
	/*
	 * one day this lot should be in a bounding sphere or some such...
	 */
	return(trace(r, o->obj.cmp->oblist, last));
}

/*
 * compn
 *
 *	it's a bit of worry if this is called.
 */
/*ARGSUSED*/
void
compn(n, l, o)
	vector *n, *l;
	object *o;
{
	fatal("art: bad function call to composite normal.\n");
}

/*
 * compinit
 *
 *	initialise the function pointers and fields for a composite object,
 * returning its pointer.
 */
object *
compinit(d)
	details *d;
{
	object		*o;
	details		*ld;
	composite	*cmp;

	o = (object *)smalloc(sizeof(object));
	o->type = COMPOSITE;
	o->intersects = compi;
	o->normal = compn;

	cmp = o->obj.cmp = (composite *)smalloc(sizeof(composite));

	cmp->oblist = (object *)NULL;

	while (d != (details *)NULL) {
		switch (d->type) {
		case OBJECT:
			d->u.obj->nxt = cmp->oblist;
			cmp->oblist = d->u.obj;
			break;
		default:
			warning("art: illegal field in composite ignored.\n");
		}
		ld = d;
		d = d->nxt;
		free(ld);
	}

	return(o);
}
