/*
 * Convert TARGA format image to pixel format image.
 *
 * Usage:
 *		 targ2pix targafile rgbfile
 *
 *
 */

#include <stdio.h>
#ifdef MSC
#include <stdlib.h>
#endif
#include "vort.h"

#define	TRUE	1
#define	FALSE	!TRUE

typedef	struct {
	char		pad1[12];
	unsigned	pw;
	unsigned	ph;
	char		pad2[2];
} TGA_HEADER;


int
main(argc, argv)
	int	argc;
	char	*argv[];
{
	FILE		*fin;
	image		*iout;
	TGA_HEADER	tga_header;
	unsigned	*tga_line;
	char		*infn = NULL, *outfn = NULL;
	char		*r, *g, *b;
	int		i, nlines, chatty = FALSE, shift = TRUE;

	if (argc < 3 || argc > 4)
		usage();

	for (i = 1; i < argc; i++) {
		if (argv[i][0] == '-' || argv[i][0] == '/') {
			if (strlen(argv[i]) != 2) usage();
			switch (argv[i][1]) {
			case 'v' :
				chatty = TRUE;
				break;
			case 's' :
				shift = 0;
				break;
			default :
				usage();
			}
		} else if (infn == NULL)
			infn = argv[i];
		else
			outfn = argv[i];
	}

	/* open TARGA file */
#ifdef MSC
	if ((fin = fopen(infn, "rb")) == NULL) {
#else
	if ((fin = fopen(infn, "r")) == NULL) {
#endif
		fprintf(stderr, "Can't read TARGA file: %s\n", infn);
		exit(1);
	}
	if (fread(&tga_header, sizeof(TGA_HEADER), 1, fin) != 1) {
		fprintf(stderr, "Can't read TARGA header: %s\n", infn);
		exit(1);
	}

	if ((iout = openimage(outfn, "w")) == NULL) {
		fprintf(stderr, "Can't create RGB file: %s\n", outfn);
		exit(1);
	}

	imagetype(iout) = PIX_RGB;
	iout->pixw = tga_header.pw;
	iout->pixh = nlines = tga_header.ph;
	iout->tlength = 0;
	iout->date = 0;
	writeheader(iout);

	if ((tga_line = (unsigned *)malloc(tga_header.pw * sizeof(unsigned))) == NULL) {
		fprintf(stderr, "Not enough space for TARGA scanline: %d\n", tga_header.pw * 2);
		exit(1);
	}
	if ((r = (char *)malloc(tga_header.pw)) == NULL) {
		fprintf(stderr, "Not enough space for r scanline: %d\n", tga_header.pw);
		exit(1);
	}
	if ((g = (char *)malloc(tga_header.pw)) == NULL) {
		fprintf(stderr, "Not enough space for g scanline: %d\n", tga_header.pw);
		exit(1);
	}
	if ((b = (char *)malloc(tga_header.pw)) == NULL) {
		fprintf(stderr, "Not enough space for b scanline: %d\n", tga_header.pw);
		exit(1);
	}

	while (!feof(fin) && nlines) {
		if (fread(tga_line, sizeof(unsigned), tga_header.pw, fin) != tga_header.pw) {
			fprintf(stderr, "targ2pix: Can't read file: %s, too short.\n", infn);
			exit(1);
		}

		for (i = 0; i < tga_header.pw; i++) {
			if (shift) {
				r[i] = (char) ((tga_line[i] & 0x7c00) >> 10) << 3;
				g[i] = (char) ((tga_line[i] & 0x03e0) >> 5) << 3;
				b[i] = (char) (tga_line[i] & 0x1f) << 3;
			} else {
				r[i] = (char) ((tga_line[i] & 0x7c00) >> 10);
				g[i] = (char) ((tga_line[i] & 0x03e0) >> 5);
				b[i] = (char) (tga_line[i] & 0x1f);
			}
		}

		writergbline(iout, r, g, b);
		nlines--;
		if (chatty)
			fprintf(stderr, "%5.5d <-- %5.5d\r", tga_header.ph, nlines);
	}
	if (chatty)
		fprintf(stderr, "\n");
	if (nlines > 0) {
		fprintf(stderr, "File %s too short by %d scanlines", infn, nlines);
		exit(1);
	}
	fclose(fin);
}


int	
usage()
{
	fprintf(stderr, "convert TARGA format image to RGB format\n\n");
	fprintf(stderr, "usage:  targ2pix targafile rgbfile [-v]\n\n");
	fprintf(stderr, "            -v       verbose\n");
	fprintf(stderr, "            -s       turn off shifting\n");
	exit(1);
}
