/*
 * Header file for VORT pcdisp.
 *
 */

#ifndef TRUE
#define TRUE	1
#define FALSE	0
#endif

#define	MAX_PALETTE	256			/* max size of a colour palette */
#define	MAX_IMGWIDTH	2048	/* max width for an image */

typedef unsigned char UCHAR;
typedef UCHAR (far *VIDEO);		/* far pointer to video memory */
typedef int (*PFI)();			/* pointer to function returning int */

/* video adapter info */
typedef struct _ADAPTER {		/* description of adapter */
			char	descr[80];		/* text description of adapter (for usage info) */
			int		width,			/* max width in pixels */
					height,			/* max height in pixels */
					depth;			/* max depth in bits */
								/* functions */
			PFI		init,			/* initialize the device */
					line,			/* copy a line of pixels */
					block,			/* copy a block of pixels */
					erase,			/* erase block of pixels */
					palette,		/* set colour palette */
					overscan,		/* set overscan palette index */
					front,			/* write to front video buffer */
					back,			/* write to back video buffer */
					swap,			/* swap front and back buffers */
					text;			/* write text */
			} ADAPTER;

/*

	Adapter functions:

		setup_xxxx()		- called explictly by main() to set ADAPTER stuff
		init()				- puts adapter into required graphics mode
		line(p, w, x, y)	- writes pixel line "p" of pixel width "w" at co-ord (x,y)
							  to selected video buffer (front or back). The line should
							  be clipped.
		block(p, w, h, x, y)- writes a block of pixels "p" of pixel width "w"
							  and height "h" starting at top left co-ord (x,y) to selected
							  video buffer (front or back). The block should be clipped.
		erase(c)			- sets entire video buffer to palette colour index "c"
		palette(p, size)	- sets first "size" colour palette entries to values in "p".
							  "p" palette entries are groups of 3 unsigned chars (r, g, b).
		overscan(c)			- sets the overscan palette colour index to "c"
		front()				- select the front video buffer. Does nothing if double buffering
							  is not possible or practical.
		back()				- select the back video buffer. Does nothing if double buffering
							  is not possible or practical.
		swap()				- swaps the front video buffer. Does nothing if double buffering
							  is not possible or practical.
		text(p, x, y)		- write text "p" to video buffer at top left co-ord (x,y)

*/

