/*
 * header details for pixel files
 */
#define	VSTR_SIZE	6
#define	VERSION_STR	"VORT01"

/*
 * tag values 
 */
#define	V_DIRECTORY	0	/* directory */

#define	D_PARENT	0	/* address of parent directory */
#define	D_NULL		1	/* empty entry */
#define	D_OBJECT	2	/* address of object in directory */

#define	V_IMAGE		1	/* image */

#define	I_ADDR		0	/* size of image in file */		
#define	I_IMWIDTH	1	/* image width in pixels */
#define	I_IMHEIGHT	2	/* image height in pixels */
#define	I_IMDEPTH	3	/* image depth in bits */
#define	I_RED		4	/* red channel present */
#define	I_GREEN		5	/* green channel present */
#define	I_BLUE		6	/* blue channel present */
#define	I_ALPHA		7	/* alpha channel present */
#define	I_BACKGND	8	/* background colour */
#define	I_DATE		9	/* creation date */
#define	I_COLORMAP	10	/* red, green, and blue channels in colourmap */
#define	I_RLE_CODED	11	/* image is run length encoded */

#define	V_TEXT		2	/* text */

#define	T_ADDR		0	/* address of text in file */
#define	T_LENGTH	1	/* length of text in characters */

#define	V_COLORMAP	3	/* colourmap */

#define	C_ADDR		0	/* size of map */
#define	C_SIZE		1	/* size of each channel */
#define	C_RED		2	/* red channel present */
#define	C_GREEN		3	/* green channel present */
#define	C_BLUE		4	/* blue channel present */

/*
 * header details for pixel files
 */
#define	_BASE		0xffff0000	/* base of magic number */

/*
 * format types
 */
#define	_FLAT		0x0000		/* straight rasters */
#define	_RLE_CODED	0x1000		/* mixed run-length encoded file */
#define _COLOR_MAP	0x2000		/* colour mapped image */

/*
 * limits
 */
#define	PIX_MAXRUN	127		/* max run in run-length encoded */

/*
 * channel types
 */
#define	_R		0x0100		/* red channel */
#define	_G		0x0200		/* green channel */
#define	_B		0x0400		/* blue channel */
#define	_A		0x0800		/* alpha channel */

/*
 * magic numbers and their format structures
 *	- type order is the same as byte order
 */
#define	PIX_RGB		(_R | _G | _B)
#define	PIX_RLE		(_RLE_CODED | _R | _G | _B)
#define	PIX_RGBA	(_R | _G | _B | _A)
#define	PIX_RLEA	(_RLE_CODED | _R | _G | _B | _A)

/*
 * colour map type - currently max size 256 so each pixel is a single byte index
 */
#define	PIX_CMAP	(_COLOR_MAP | _R | _G | _B)
#define	PIX_RLECMAP	(_COLOR_MAP | _RLE_CODED | _R | _G | _B)

/*
 * file name suffix
 */
#define	PIX_SUFFIX	".pix"

/*
 * VORT object structure
 */
typedef struct __vo {
	unsigned int	type;
	unsigned int	size;
	unsigned char	*ptr;
} v_object;

typedef struct __co {
	unsigned int	r, g, b;
} v_color;

/*
 * image structure details
 */

#define	IBUF_SIZE	4096			/* default size of image buffer */

typedef struct __i {
	int		fd;			/* file descriptor */
	int		reading;		/* are we open for reading? */
	int		written;		/* written to the file? */
	unsigned long	imaddr;			/* address of the image */
	unsigned long	cmaddr;			/* address of the colormap */
	int		magic;			/* magic number */
	unsigned short	pixw, pixh, pixd;	/* width and height in pixels */
	long		date;			/* date created (secs from 1/1/70) */
	int		tlength;		/* length of title */
	char		*title;			/* image title */
	v_color		background;		/* background colour */
	unsigned char	run,			/* current position in run */
			r, g, b, a;		/* current pixel */
	int		ibufsize;		/* image buffer size - bytes */
	unsigned char	*ibuf;			/* pointer to image buffer */
	unsigned char	*ibufp;			/* pointer to buffer position */
	unsigned char	*ebufp;			/* pointer to end of buffer */
	unsigned short	mapsize;
	unsigned char	*red, *green, *blue;	/* colour map details */
} image;

/*
 * macros for checking and setting the type from the magic number
 */
#define	imagetype(a)		(a)->magic

#define	redchannel(a)		((a)->magic & _R)
#define	greenchannel(a)		((a)->magic & _G)
#define	bluechannel(a)		((a)->magic & _B)
#define	alphachannel(a)		((a)->magic & _A)

#define colormapped(a)		((a)->magic & _COLOR_MAP)

#define rlecoded(a)		((a)->magic & _RLE_CODED)

/*
 * image processing functions
 */
extern image	*openimage();
extern int	readrgbline(), writergbline();
extern int	readrgbaline(), writergbaline();

/*
 * general macros for getting access to image details
 */
#define	imagewidth(a)	(a)->pixw
#define	imageheight(a)	(a)->pixh
#define	imagedepth(a)	(a)->pixd

#define	imagedate(a)	(a)->date

#define	imagefile(a)	(a)->fd

#define	imagetitle(a)	(a)->title
#define	titlelength(a)	(a)->tlength

#define	cmapsize(a)	(a)->mapsize

#define	redmap(a)	(a)->red
#define	greenmap(a)	(a)->green
#define	bluemap(a)	(a)->blue

#define	imagebackgnd(a)	(a)->background

